/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientBean;
import com.jurismarches.vradi.services.dto.SendingContainer;
import com.jurismarches.vradi.services.dto.VradiDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiUserDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class VradiClientDTO
extends ClientBean
implements VradiDTO<Client>,
SendingContainer {
    private static final long serialVersionUID = 1L;
    protected List<VradiUserDTO> usersDTO = null;
    protected VradiSendingDTO currentSending = null;

    public VradiClientDTO() {
        this.QueryMaker$queries = new HashSet();
        this.usersDTO = new ArrayList<VradiUserDTO>();
    }

    @Override
    public void fromWikitty(Client wikitty) {
        if (wikitty == null) {
            this.reset();
        } else {
            this.setWikittyId(wikitty.getWikittyId());
            this.setAddress(wikitty.getAddress());
            this.setContact(wikitty.getContact());
            this.setCreationDate(wikitty.getCreationDate());
            this.setName(wikitty.getName());
            this.setPhone(wikitty.getPhone());
            if (wikitty.getExtensionNames().contains("ModificationTag")) {
                Object lastModified = wikitty.getField("ModificationTag", "lastModified");
                this.setLastModified(lastModified != null ? (Date)lastModified : null);
                Object lastModifier = wikitty.getField("ModificationTag", "lastModifier");
                this.setLastModifier(lastModifier != null ? (String)lastModifier : null);
            } else {
                this.setLastModified(null);
                this.setLastModifier(null);
            }
            this.QueryMaker$queries.clear();
            this.addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        this.setWikittyId(null);
        this.setAddress(null);
        this.setContact(null);
        this.setCreationDate(null);
        this.setName(null);
        this.setPhone(null);
        this.setLastModified(null);
        this.setLastModifier(null);
        this.clearQueries();
    }

    @Override
    public void toWikitty(Client wikitty) {
        wikitty.setAddress(this.getAddress());
        wikitty.setContact(this.getContact());
        wikitty.setCreationDate(this.getCreationDate());
        wikitty.setName(this.getName());
        wikitty.setPhone(this.getPhone());
        wikitty.setField("ModificationTag", "lastModified", (Object)this.getLastModified());
        wikitty.setField("ModificationTag", "lastModifier", (Object)this.getLastModifier());
        wikitty.clearQueries();
        for (String id : this.getQueries()) {
            wikitty.addQueries(id);
        }
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        this.propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date)this.getField("ModificationTag", "lastModified");
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = this.getLastModified();
        this.setField("ModificationTag", "lastModified", lastModified);
        this.propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String)this.getField("ModificationTag", "lastModifier");
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = this.getLastModifier();
        this.setField("ModificationTag", "lastModifier", lastModifier);
        this.propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                this.QueryMaker$queries.add(s);
            }
        }
        this.propertyChange.firePropertyChange("queries", null, this.QueryMaker$queries);
    }

    public List<VradiUserDTO> getUsersDTO() {
        return this.usersDTO;
    }

    public void setUsersDTO(List<VradiUserDTO> usersDTO) {
        List<VradiUserDTO> oldValue = this.usersDTO;
        this.usersDTO = usersDTO;
        this.propertyChange.firePropertyChange("usersDTO", oldValue, usersDTO);
    }

    @Override
    public VradiSendingDTO getCurrentSending() {
        return this.currentSending;
    }

    @Override
    public void setCurrentSending(VradiSendingDTO currentSending) {
        this.currentSending = currentSending;
    }

    @Override
    public int getNbFormToSend() {
        int nbForms = 0;
        for (VradiUserDTO user : this.getUsersDTO()) {
            nbForms += user.getNbFormToSend();
        }
        return nbForms;
    }

    public String toString() {
        return this.getName();
    }
}

