/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.compiler;

import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.util.Strings;

public final class CompilationInfo {
    private final Model m_initialModel;
    private Model m_redefinedModel;
    private int m_redefinitionCounter = 0;

    public CompilationInfo(Model initialModel) {
        this.m_initialModel = initialModel;
    }

    public Model getInitialModel() {
        return this.m_initialModel;
    }

    public Model getRedefinedModel() {
        return this.m_redefinedModel;
    }

    public void setRedefinedModel(Model redefinedModel) {
        this.m_redefinedModel = redefinedModel;
    }

    public int getRedefinitionCounter() {
        return this.m_redefinitionCounter;
    }

    public void incrementRedefinitionCounter() {
        ++this.m_redefinitionCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompilationInfo)) {
            return false;
        }
        CompilationInfo compilationInfo = (CompilationInfo)o;
        if (this.m_redefinitionCounter != compilationInfo.m_redefinitionCounter) {
            return false;
        }
        if (this.m_initialModel != null ? !this.m_initialModel.equals(compilationInfo.m_initialModel) : compilationInfo.m_initialModel != null) {
            return false;
        }
        return !(this.m_redefinedModel != null ? !this.m_redefinedModel.equals(compilationInfo.m_redefinedModel) : compilationInfo.m_redefinedModel != null);
    }

    public int hashCode() {
        int result = this.m_initialModel != null ? this.m_initialModel.hashCode() : 0;
        result = 29 * result + (this.m_redefinedModel != null ? this.m_redefinedModel.hashCode() : 0);
        result = 29 * result + this.m_redefinitionCounter;
        return result;
    }

    public static final class Model {
        private final String m_joinPointClassName;
        private final EmittedJoinPoint m_emittedJoinPoint;
        private final AdviceInfoContainer m_adviceInfoContainer;
        private final ClassInfo m_thisClassInfo;

        public Model(EmittedJoinPoint emittedJoinPoint, AdviceInfoContainer adviceInfoContainer, ClassInfo thisClassInfo) {
            this.m_emittedJoinPoint = emittedJoinPoint;
            this.m_adviceInfoContainer = adviceInfoContainer;
            this.m_joinPointClassName = this.m_emittedJoinPoint.getJoinPointClassName();
            this.m_thisClassInfo = thisClassInfo;
        }

        public Model(EmittedJoinPoint emittedJoinPoint, AdviceInfoContainer adviceInfoContainer, int redefinitionCounter, ClassInfo thisClassInfo) {
            this.m_emittedJoinPoint = emittedJoinPoint;
            this.m_adviceInfoContainer = adviceInfoContainer;
            this.m_joinPointClassName = Strings.replaceSubString(this.m_emittedJoinPoint.getJoinPointClassName(), "___AW_JoinPoint", "" + '_' + redefinitionCounter + "___AW_JoinPoint");
            this.m_thisClassInfo = thisClassInfo;
        }

        public String getJoinPointClassName() {
            return this.m_joinPointClassName;
        }

        public EmittedJoinPoint getEmittedJoinPoint() {
            return this.m_emittedJoinPoint;
        }

        public AdviceInfoContainer getAdviceInfoContainer() {
            return this.m_adviceInfoContainer;
        }

        public ClassInfo getThisClassInfo() {
            return this.m_thisClassInfo;
        }

        public int hashCode() {
            return this.m_emittedJoinPoint.hashCode();
        }

        public boolean equals(Object o) {
            return ((Model)o).m_emittedJoinPoint == this.m_emittedJoinPoint;
        }
    }
}

