/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.aspectwerkz.compiler.AspectWerkzC;

public class AspectWerkzCTask
extends Task {
    private static final String AW_TRANSFORM_DETAILS = "aspectwerkz.transform.details";
    private static final String AW_TRANSFORM_VERBOSE = "aspectwerkz.transform.verbose";
    private static final String AW_DEFINITION_FILE = "aspectwerkz.definition.file";
    private boolean m_verbose;
    private boolean m_details;
    private boolean m_genjp;
    private boolean m_taskVerbose = false;
    private String m_aspectModels;
    private File m_backupdir;
    private String m_preprocessor;
    private File m_definitionFile;
    private Path m_classpath;
    private Path m_target;

    public void setDefinition(File defFile) {
        this.m_definitionFile = defFile;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setDetails(boolean details) {
        this.m_details = details;
    }

    public void setGenjp(boolean genjp) {
        this.m_genjp = genjp;
    }

    public void setTaskVerbose(boolean verbose) {
        this.m_taskVerbose = verbose;
    }

    public void setAspectModels(String aspectModels) {
        this.m_aspectModels = aspectModels;
    }

    public Path createTarget() {
        if (this.m_target == null) {
            this.m_target = new Path(this.getProject());
        }
        return this.m_target.createPath();
    }

    public void setTargetdir(Path srcDir) {
        if (this.m_target == null) {
            this.m_target = srcDir;
        } else {
            this.m_target.append(srcDir);
        }
    }

    public void setTargetpath(Path targetpath) {
        if (this.m_target == null) {
            this.m_target = targetpath;
        } else {
            this.m_target.append(targetpath);
        }
    }

    public Path createTargetpath() {
        if (this.m_target == null) {
            this.m_target = new Path(this.getProject());
        }
        return this.m_target.createPath();
    }

    public void setTargetpathRef(Reference r) {
        this.createTargetpath().setRefid(r);
    }

    public void setBackupdir(File backupDir) {
        this.m_backupdir = backupDir;
    }

    public void setPreprocessor(String preprocessorFqn) {
        this.m_preprocessor = preprocessorFqn;
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void execute() throws BuildException {
        try {
            if (this.m_definitionFile != null && this.m_definitionFile.exists() && !this.m_definitionFile.isFile()) {
                throw new BuildException("Definition file provided does not exists");
            }
            AspectWerkzC compiler = new AspectWerkzC();
            compiler.setHaltOnError(true);
            compiler.setVerbose(this.m_taskVerbose);
            compiler.setGenJp(this.m_genjp);
            compiler.setVerify(false);
            if (this.m_definitionFile != null) {
                System.setProperty(AW_DEFINITION_FILE, this.m_definitionFile.getAbsolutePath());
            }
            if (this.m_verbose) {
                System.setProperty(AW_TRANSFORM_VERBOSE, this.m_verbose ? "true" : "false");
            }
            if (this.m_details) {
                System.setProperty(AW_TRANSFORM_DETAILS, this.m_details ? "true" : "false");
            }
            if (this.m_aspectModels != null) {
                System.setProperty("aspectwerkz.extension.aspectmodels", this.m_aspectModels);
            }
            if (this.m_backupdir != null && this.m_backupdir.isDirectory()) {
                compiler.setBackupDir(this.m_backupdir.getAbsolutePath());
            }
            if (this.m_taskVerbose) {
                System.out.println("Classpath    : " + this.dump(this.getDirectories(this.m_classpath)));
                System.out.println("Target       : " + this.dump(this.getDirectories(this.m_target)));
                System.out.println("Definition   : " + this.m_definitionFile);
                System.out.println("Backupdir    : " + this.m_backupdir);
                System.out.println("Preprocessor : " + this.m_preprocessor);
            }
            AspectWerkzC.compile(compiler, ((Object)((Object)this)).getClass().getClassLoader(), this.m_preprocessor, this.getDirectories(this.m_classpath), this.getDirectories(this.m_target));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e, this.getLocation());
        }
    }

    private List getDirectories(Path path) throws BuildException {
        ArrayList<File> dirs = new ArrayList<File>();
        if (path == null) {
            return dirs;
        }
        for (int i = 0; i < path.list().length; ++i) {
            File dir = this.getProject().resolveFile(path.list()[i]);
            if (!dir.exists()) {
                throw new BuildException(" \"" + dir.getPath() + "\" does not exist!", this.getLocation());
            }
            dirs.add(dir);
        }
        return dirs;
    }

    private String dump(List strings) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            sb.append(o.toString()).append(File.pathSeparator);
        }
        return sb.toString();
    }
}

