/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.aspect.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.codehaus.aspectwerkz.aspect.MixinFactory;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.util.ContextClassLoader;

public class Mixins {
    public static final String DEFAULT_MIXIN_FACTORY = (class$org$codehaus$aspectwerkz$aspect$DefaultMixinFactory == null ? (class$org$codehaus$aspectwerkz$aspect$DefaultMixinFactory = Mixins.class$("org.codehaus.aspectwerkz.aspect.DefaultMixinFactory")) : class$org$codehaus$aspectwerkz$aspect$DefaultMixinFactory).getName();
    private static final Map MIXIN_FACTORIES = new WeakHashMap();
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$aspect$DefaultMixinFactory;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$DeploymentModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MixinFactory getFactory(Class mixinClass, ClassLoader mixinCalledFromLoader) {
        Map map = MIXIN_FACTORIES;
        synchronized (map) {
            MixinFactory factory = (MixinFactory)MIXIN_FACTORIES.get(mixinClass);
            if (factory == null) {
                factory = Mixins.createMixinFactory(mixinClass, mixinCalledFromLoader);
                MIXIN_FACTORIES.put(mixinClass, factory);
            }
            return factory;
        }
    }

    public static Object mixinOf(String name, ClassLoader loader) {
        try {
            Class<?> mixinClass = Class.forName(name, false, loader);
            return Mixins.mixinOf(mixinClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load mixin " + name + " from " + loader);
        }
    }

    public static Object mixinOf(Class mixinClass) {
        return Mixins.getFactory(mixinClass, mixinClass.getClassLoader()).mixinOf();
    }

    public static Object mixinOf(String name, Class targetClass) {
        try {
            Class<?> mixinClass = Class.forName(name, false, targetClass.getClassLoader());
            return Mixins.mixinOf(mixinClass, targetClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load mixin " + name + " from " + targetClass.getClassLoader());
        }
    }

    public static Object mixinOf(Class mixinClass, Class targetClass) {
        return Mixins.getFactory(mixinClass, targetClass.getClassLoader()).mixinOf(targetClass);
    }

    public static Object mixinOf(String name, Object targetInstance) {
        try {
            Class<?> mixinClass = Class.forName(name, false, targetInstance.getClass().getClassLoader());
            return Mixins.mixinOf(mixinClass, targetInstance);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("could not load mixin " + name + " from " + targetInstance.getClass().getClassLoader());
        }
    }

    public static Object mixinOf(Class mixinClass, Object targetInstance) {
        return Mixins.getFactory(mixinClass, targetInstance.getClass().getClassLoader()).mixinOf(targetInstance);
    }

    private static MixinFactory createMixinFactory(Class mixinClass, ClassLoader mixinCalledFromLoader) {
        MixinDefinition mixinDefinition = Mixins.getMixinDefinition(mixinClass, mixinCalledFromLoader);
        String factoryClassName = mixinDefinition.getFactoryClassName();
        try {
            Class containerClass = factoryClassName == null ? ContextClassLoader.forName(mixinClass.getClassLoader(), DEFAULT_MIXIN_FACTORY) : ContextClassLoader.forName(mixinClass.getClassLoader(), factoryClassName);
            Constructor constructor = containerClass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = Mixins.class$("java.lang.Class")) : class$java$lang$Class, class$org$codehaus$aspectwerkz$DeploymentModel == null ? (class$org$codehaus$aspectwerkz$DeploymentModel = Mixins.class$("org.codehaus.aspectwerkz.DeploymentModel")) : class$org$codehaus$aspectwerkz$DeploymentModel);
            MixinFactory factory = (MixinFactory)constructor.newInstance(mixinClass, mixinDefinition.getDeploymentModel());
            return factory;
        }
        catch (InvocationTargetException e) {
            throw new DefinitionException(e.getTargetException().toString());
        }
        catch (NoSuchMethodException e) {
            throw new DefinitionException("mixin factory does not have a valid constructor [" + factoryClassName + "] need to have a signature like this [MyMixinFactory(Class mixin, DeploymentModel scope)]: " + e.toString());
        }
        catch (Throwable e) {
            StringBuffer cause = new StringBuffer();
            cause.append("could not create mixin container using the implementation specified [");
            cause.append(factoryClassName);
            cause.append("] due to: ");
            cause.append(e.toString());
            throw new DefinitionException(cause.toString());
        }
    }

    public static Map getParameters(Class mixinClass, ClassLoader loader) {
        MixinDefinition mixinDefinition = Mixins.getMixinDefinition(mixinClass, loader);
        return mixinDefinition.getParameters();
    }

    public static MixinDefinition getMixinDefinition(Class mixinClass, ClassLoader visibleFrom) {
        MixinDefinition mixinDefinition = null;
        Set definitions = SystemDefinitionContainer.getDefinitionsFor(visibleFrom);
        Iterator iterator = definitions.iterator();
        block0: while (iterator.hasNext() && mixinDefinition == null) {
            SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
            Iterator iterator1 = systemDefinition.getMixinDefinitions().iterator();
            while (iterator1.hasNext()) {
                MixinDefinition mixinDef = (MixinDefinition)iterator1.next();
                if (!mixinClass.getName().replace('/', '.').equals(mixinDef.getMixinImpl().getName())) continue;
                mixinDefinition = mixinDef;
                continue block0;
            }
        }
        if (mixinDefinition == null) {
            throw new DefinitionException("could not find definition for mixin: " + mixinClass.getName() + " (loader " + mixinClass.getClassLoader() + ")" + " from loader " + visibleFrom);
        }
        return mixinDefinition;
    }

    private Mixins() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

