/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation.instrumentation.asm;

import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.AnnotationDefault;
import org.codehaus.aspectwerkz.annotation.AnnotationInfo;
import org.codehaus.aspectwerkz.annotation.Java5AnnotationInvocationHandler;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.CustomAttributeHelper;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.Annotation;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.AnnotationDefaultAttribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.RuntimeInvisibleAnnotations;
import org.codehaus.aspectwerkz.org.objectweb.asm.attrs.RuntimeVisibleAnnotations;

public class AsmAnnotationHelper {
    private static final String INIT_METHOD_NAME = "<init>";

    public static List extractAnnotations(List annotations, Attribute attribute, ClassLoader loader) {
        Attribute current = attribute;
        while (current != null) {
            AnnotationInfo annotationInfo;
            Annotation annotation;
            Iterator it;
            if (current instanceof RuntimeInvisibleAnnotations) {
                it = ((RuntimeInvisibleAnnotations)current).annotations.iterator();
                while (it.hasNext()) {
                    annotation = (Annotation)it.next();
                    if ("Lorg/codehaus/aspectwerkz/annotation/instrumentation/asm/CustomAttribute;".equals(annotation.type)) {
                        annotations.add(CustomAttributeHelper.extractCustomAnnotation(annotation));
                        continue;
                    }
                    annotationInfo = AsmAnnotationHelper.getAnnotationInfo(annotation, loader);
                    annotations.add(annotationInfo);
                }
            } else if (current instanceof RuntimeVisibleAnnotations) {
                it = ((RuntimeVisibleAnnotations)current).annotations.iterator();
                while (it.hasNext()) {
                    annotation = (Annotation)it.next();
                    annotationInfo = AsmAnnotationHelper.getAnnotationInfo(annotation, loader);
                    annotations.add(annotationInfo);
                }
            } else if (current instanceof AnnotationDefaultAttribute) {
                AnnotationDefaultAttribute defaultAttribute = (AnnotationDefaultAttribute)current;
                AnnotationInfo annotationInfo2 = new AnnotationInfo(AnnotationDefault.NAME, new AnnotationDefault.AnnotationDefaultImpl(defaultAttribute.defaultValue));
                annotations.add(annotationInfo2);
            }
            current = current.next;
        }
        return annotations;
    }

    public static AnnotationInfo getAnnotationInfo(Annotation annotation, ClassLoader loader) {
        String annotationName = Type.getType(annotation.type).getClassName();
        return new AnnotationInfo(annotationName, Java5AnnotationInvocationHandler.getAnnotationProxy(annotation, loader));
    }

    public static class NullCodeAdapter
    implements CodeVisitor {
        public static final CodeVisitor NULL_CODE_ADAPTER = new NullCodeAdapter();

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String desc) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitLocalVariable(String name, String desc, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitAttribute(Attribute attr) {
        }
    }

    public static class NullClassAdapter
    implements ClassVisitor {
        public static final ClassVisitor NULL_CLASS_ADAPTER = new NullClassAdapter();

        public void visit(int i, int i1, String s, String s1, String[] strings, String s2) {
        }

        public void visitInnerClass(String s, String s1, String s2, int i) {
        }

        public void visitField(int i, String s, String s1, Object o, Attribute attribute) {
        }

        public CodeVisitor visitMethod(int i, String s, String s1, String[] strings, Attribute attribute) {
            return NullCodeAdapter.NULL_CODE_ADAPTER;
        }

        public void visitAttribute(Attribute attribute) {
        }

        public void visitEnd() {
        }
    }

    public static class FieldAnnotationExtractor
    extends MemberAnnotationExtractor {
        public FieldAnnotationExtractor(List annotations, String name, ClassLoader loader) {
            super(annotations, name, null, loader);
        }

        public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
            if (name.equals(this.m_name)) {
                this.m_annotations = AsmAnnotationHelper.extractAnnotations(this.m_annotations, attrs, this.m_loader);
            }
            super.visitField(access, name, desc, value, attrs);
        }
    }

    public static class ConstructorAnnotationExtractor
    extends MethodAnnotationExtractor {
        public ConstructorAnnotationExtractor(List annotations, String desc, ClassLoader loader) {
            super(annotations, AsmAnnotationHelper.INIT_METHOD_NAME, desc, loader);
        }
    }

    public static class MethodAnnotationExtractor
    extends MemberAnnotationExtractor {
        public MethodAnnotationExtractor(List annotations, String name, String desc, ClassLoader loader) {
            super(annotations, name, desc, loader);
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            if (name.equals(this.m_name) && desc.equals(this.m_desc)) {
                this.m_annotations = AsmAnnotationHelper.extractAnnotations(this.m_annotations, attrs, this.m_loader);
            }
            return super.visitMethod(access, name, desc, exceptions, attrs);
        }
    }

    private static class MemberAnnotationExtractor
    extends AnnotationExtractor {
        protected String m_name;
        protected String m_desc;

        private MemberAnnotationExtractor(List annotations, String name, String desc, ClassLoader loader) {
            super(annotations, loader);
            this.m_name = name;
            this.m_desc = desc;
        }
    }

    public static class ClassAnnotationExtractor
    extends AnnotationExtractor {
        public ClassAnnotationExtractor(List annotations, ClassLoader loader) {
            super(annotations, loader);
        }

        public void visitAttribute(Attribute attribute) {
            this.m_annotations = AsmAnnotationHelper.extractAnnotations(this.m_annotations, attribute, this.m_loader);
            super.visitAttribute(attribute);
        }
    }

    private static class AnnotationExtractor
    extends NullClassAdapter {
        protected List m_annotations;
        protected ClassLoader m_loader;

        private AnnotationExtractor(List annotations, ClassLoader loader) {
            this.m_annotations = annotations;
            this.m_loader = loader;
        }
    }
}

