/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiConfig;
import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageServiceImpl;
import com.jurismarches.vradi.ui.ChangeLogHandler;
import com.jurismarches.vradi.ui.OfferEditHandler;
import com.jurismarches.vradi.ui.OfferListHandler;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.ProgressBarUI;
import com.jurismarches.vradi.ui.ThesaurusHandler;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.admin.AdminHandler;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.email.EmailHandler;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.AboutPanel;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIBuilder;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import jaxx.runtime.swing.editor.config.model.ConfigUIModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.FileUtil;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.WikittyExtension;

@DefaultApplicationContext.AutoLoad
public class VradiMainUIHandler {
    private static Log log = LogFactory.getLog(VradiMainUIHandler.class);
    public static final String XML_FILE_EXTENSION = ".xml";

    public VradiMainUI initUI(JAXXContext rootContext, boolean fullscreen) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        VradiMainUI ui = new VradiMainUI((JAXXContext)context);
        VradiContext.MAIN_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class).initThesaurusDef();
        ErrorDialogUI.init((Frame)ui);
        ui.getGraphicsConfiguration().getDevice().setFullScreenWindow(fullscreen ? ui : null);
        OfferListHandler handler = UIHelper.getHandler(rootContext, OfferListHandler.class);
        this.changeContent((JAXXContext)context, handler.initUI((JAXXContext)ui, this));
        return ui;
    }

    public void changeContent(JAXXContext context, JComponent content) {
        VradiMainUI ui = this.getUI(context);
        ui.setContentPane(content);
        ui.setVisible(true);
    }

    public void edit(JAXXContext context, Form data) {
        OfferEditHandler handler = UIHelper.getHandler(context, OfferEditHandler.class);
        this.changeContent((JAXXContext)VradiContext.get(), handler.initUI(context, data));
    }

    public void goToHome(JAXXContext context) {
        OfferListHandler handler = UIHelper.getHandler(context, OfferListHandler.class);
        this.changeContent(context, handler.initUI(context, this));
    }

    public void changeLanguage(VradiMainUI mainUI, Locale newLocale) {
        VradiConfig config = mainUI.getConfig();
        config.setLocale(newLocale);
        I18n.init((Locale)newLocale);
        this.reloadUI(VradiContext.get(), config.isFullScreen());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(VradiMainUI ui) {
        log.info((Object)"Vradi quitting...");
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        try {
            ui.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    public void changeScreen(VradiMainUI ui, boolean fullscreen) {
        boolean canContinue = this.ensureModification((JAXXContext)ui);
        if (!canContinue) {
            return;
        }
        ui.getConfig().setFullscreen(fullscreen);
        this.reloadUI(VradiContext.get(), fullscreen);
    }

    protected void openAdminPopup(JAXXContext rootContext, int i) {
        AdminHandler handler = UIHelper.getHandler(rootContext, AdminHandler.class);
        AdminPopupUI ui = handler.init(rootContext, new Object[0]);
        ui.showTab(i);
        ui.setVisible(true);
    }

    protected void openEmailPopup(JAXXContext rootContext, int i) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            VradiMainUI mainUI = this.getUI(rootContext);
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)new EmailHandler());
            ui = new EmailPopupUI((JAXXContext)context);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        ui.showTab(i);
        ui.setVisible(true);
    }

    public void showAdminClient(JAXXContext context) {
        this.openAdminPopup(context, 0);
    }

    public void showAdminGroup(JAXXContext context) {
        this.openAdminPopup(context, 1);
    }

    public void showAdminForm(JAXXContext context) {
        this.openAdminPopup(context, 2);
    }

    public void showAdminXmlStream(JAXXContext context) {
        this.openAdminPopup(context, 3);
    }

    public void showAdminThesaurus(JAXXContext context) {
        this.openAdminPopup(context, 5);
    }

    public void showAdminStatus(JAXXContext context) {
        this.openAdminPopup(context, 4);
    }

    public void showEmailByClient(JAXXContext context) {
        this.openEmailPopup(context, 0);
    }

    public void showEmailByForm(JAXXContext context) {
        this.openEmailPopup(context, 1);
    }

    public void showExport(JAXXContext rootContext) {
        final VradiMainUI mainUI = this.getUI(rootContext);
        final File file = UIHelper.openFileChooser(XML_FILE_EXTENSION, "vradi.export.filter.xml", mainUI, "vradi.export.validate.label");
        if (file != null) {
            mainUI.setCursor(Cursor.getPredefinedCursor(3));
            final ProgressBarUI pb = new ProgressBarUI((JAXXContext)mainUI);
            SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        String s = ServiceHelper.getVradiStorageService().exportData();
                        FileUtil.writeString((File)file, (String)s, (String)"UTF-8");
                    }
                    catch (TechnicalException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)eee.getMessage(), (Throwable)eee);
                        }
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    catch (IOException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)eee.getMessage(), (Throwable)eee);
                        }
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    return null;
                }

                @Override
                public void done() {
                    mainUI.setCursor(null);
                    pb.dispose();
                }
            };
            task.execute();
            pb.setVisible(true);
        }
    }

    public void showImport(JAXXContext rootContext) {
        final VradiMainUI mainUI = this.getUI(rootContext);
        final File file = UIHelper.openFileChooser(XML_FILE_EXTENSION, "vradi.export.filter.xml", mainUI, "vradi.import.validate.label");
        if (file != null) {
            mainUI.setCursor(Cursor.getPredefinedCursor(3));
            final ProgressBarUI pb = new ProgressBarUI((JAXXContext)mainUI);
            SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        ServiceHelper.getVradiStorageService().importData(file);
                    }
                    catch (TechnicalException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)eee.getMessage(), (Throwable)eee);
                        }
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    return null;
                }

                @Override
                public void done() {
                    mainUI.setCursor(null);
                    pb.dispose();
                }
            };
            task.execute();
            pb.setVisible(true);
        }
    }

    public void showReindex(JAXXContext rootContext) {
        final VradiMainUI mainUI = this.getUI(rootContext);
        mainUI.setCursor(Cursor.getPredefinedCursor(3));
        int answer = JOptionPane.showConfirmDialog(mainUI, I18n._((String)"vradi.reindex.message"), I18n._((String)"vradi.reindex.title"), 0);
        final ProgressBarUI pb = new ProgressBarUI((JAXXContext)mainUI);
        if (answer == 0) {
            SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        ServiceHelper.getVradiStorageService().reindexData();
                    }
                    catch (TechnicalException eee) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)eee.getMessage(), (Throwable)eee);
                        }
                        ErrorDialogUI.showError((Exception)eee);
                    }
                    return null;
                }

                @Override
                public void done() {
                    mainUI.setCursor(null);
                    pb.dispose();
                }
            };
            task.execute();
            pb.setVisible(true);
        }
    }

    public void showConfig(JAXXContext context) {
        VradiMainUI ui = this.getUI(context);
        VradiConfig config = (VradiConfig)((Object)context.getContextValue(VradiConfig.class));
        ConfigUIModelBuilder modelBuilder = new ConfigUIModelBuilder();
        modelBuilder.createModel((ApplicationConfig)config);
        modelBuilder.addCategory(I18n.n_((String)"vradi.config.category.directories"), I18n.n_((String)"vradi.config.category.directories.description"));
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.Option.CONFIG_FILE);
        modelBuilder.addCategory(I18n.n_((String)"vradi.config.category.other"), I18n.n_((String)"vradi.config.category.other.description"));
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.Option.FULL_SCREEN);
        modelBuilder.addOption((ApplicationConfig.OptionDef)VradiConfig.Option.LOCALE);
        ConfigUIModel model = modelBuilder.flushModel();
        ConfigUI configUI = ConfigUIBuilder.newConfigUI((JAXXContext)context, (ConfigUIModel)model, (String)"vradi.config.category.directories");
        ConfigUIBuilder.showConfigUI((ConfigUI)configUI, (Frame)ui, (boolean)false);
    }

    public void showHelp(JAXXContext context, String helpId) {
    }

    public void closeHelp(JAXXContext context) {
    }

    public void gotoSite(JAXXContext rootContext) {
        VradiConfig config = (VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class));
        URL siteURL = config.getOptionAsURL("application.site.url");
        log.debug((Object)("goto " + siteURL));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(siteURL.toURI());
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                ErrorDialogUI.showError((Exception)ex);
            }
        }
    }

    public void showAbout(VradiMainUI ui) {
        AboutPanel about = new AboutPanel(){
            private static final long serialVersionUID = 1L;
        };
        about.setTitle(I18n._((String)"vradi.title.about"));
        ChangeLogHandler clh = UIHelper.getHandler((JAXXContext)ui, ChangeLogHandler.class);
        about.setAboutText(clh.getLatestChangeLog());
        about.setBottomText(ui.getConfig().getCopyrightText());
        about.setLicenseFile("META-INF/vradi-swing-LICENSE.txt");
        about.setThirdpartyFile("META-INF/vradi-swing-THIRD-PARTY.txt");
        about.init();
        about.showInDialog((Frame)ui, true);
    }

    protected void reloadUI(VradiContext rootContext, boolean fullscreen) {
        ((VradiConfig)((Object)rootContext.getContextValue(VradiConfig.class))).removeJaxxPropertyChangeListener();
        VradiMainUI ui = this.getUI((JAXXContext)rootContext);
        if (ui != null) {
            ErrorDialogUI.init(null);
            VradiContext.MAIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            VradiContext.ADMIN_UI_ENTRY_DEF.removeContextValue((JAXXContext)rootContext);
            ui.dispose();
            ui.setVisible(false);
        }
        ui = this.initUI((JAXXContext)rootContext, fullscreen);
        ui.setVisible(true);
    }

    protected boolean ensureModification(JAXXContext rootContext) throws IllegalArgumentException {
        if (rootContext == null) {
            throw new IllegalArgumentException("rootContext can not be null");
        }
        VradiMainUI ui = this.getUI(rootContext);
        if (ui == null) {
            return true;
        }
        return true;
    }

    VradiMainUI getUI(JAXXContext context) {
        if (context instanceof VradiMainUI) {
            return (VradiMainUI)context;
        }
        VradiMainUI ui = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    public void createForm(JAXXContext rootContext, WikittyExtension extension) {
        OfferListUI ui = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui != null) {
            log.debug((Object)("FormType selected : " + extension));
            if (extension == null) {
                return;
            }
            FormImpl form = new FormImpl();
            form.addExtension(extension);
            form.setId(VradiStorageServiceImpl.FORM_ID_DATE_FORMAT.format(new GregorianCalendar().getTime()) + form.getWikittyId());
            UIHelper.getHandler(rootContext, OfferListHandler.class).addEditPane(ui.getDelegateContext(), form);
        }
    }

    public void createFormMenu(final VradiMainUI ui) {
        try {
            List extensions = ServiceHelper.getVradiStorageService().getAllFormTypes();
            JMenu menuForm = ui.getMenuForm();
            menuForm.removeAll();
            for (final WikittyExtension extension : extensions) {
                JMenuItem item = new JMenuItem(I18n._((String)"vradi.menu.form.new", (Object[])new Object[]{extension.getName()}));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VradiMainUIHandler.this.createForm((JAXXContext)ui, extension);
                    }
                });
                menuForm.add(item);
            }
        }
        catch (TechnicalException eee) {
            log.error((Object)("Can't load the form types : " + eee));
            ErrorDialogUI.showError((Exception)eee);
        }
    }
}

