/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.QueryDocValues;
import org.apache.solr.search.function.ValueSource;

public class QueryValueSource
extends ValueSource {
    final Query q;
    final float defVal;

    public QueryValueSource(Query q, float defVal) {
        this.q = q;
        this.defVal = defVal;
    }

    public Query getQuery() {
        return this.q;
    }

    public float getDefaultValue() {
        return this.defVal;
    }

    public String description() {
        return "query(" + this.q + ",def=" + this.defVal + ")";
    }

    public DocValues getValues(IndexReader reader) throws IOException {
        return new QueryDocValues(reader, this.q, this.defVal);
    }

    public int hashCode() {
        return this.q.hashCode() * 29;
    }

    public boolean equals(Object o) {
        if (QueryValueSource.class != o.getClass()) {
            return false;
        }
        QueryValueSource other = (QueryValueSource)o;
        return this.q.equals(other.q);
    }
}

