/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.SendingStatus;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiFormDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.VradiMainUI;
import com.jurismarches.vradi.ui.email.ClientEmailContentTableModel;
import com.jurismarches.vradi.ui.email.EmailListByClientUI;
import com.jurismarches.vradi.ui.email.EmailListByFormUI;
import com.jurismarches.vradi.ui.email.EmailPopupUI;
import com.jurismarches.vradi.ui.email.FormEmailContentTableModel;
import com.jurismarches.vradi.ui.email.ParagraphEditorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.OneClicListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.WikittyExtension;

public class EmailHandler {
    private static final Log log = LogFactory.getLog(EmailHandler.class);

    public EmailPopupUI init(JAXXContext rootContext, Object ... datas) {
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this);
            VradiMainUI mainUI = (VradiMainUI)VradiContext.MAIN_UI_ENTRY_DEF.getContextValue((JAXXContext)context);
            ui = new EmailPopupUI((JAXXContext)context, mainUI);
            VradiContext.EMAIL_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI)context;
        }
        EmailPopupUI ui = (EmailPopupUI)VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = this.getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    List<VradiSendingDTO> getFormsByClients(EmailListByClientUI ui) {
        List<Object> result;
        block2: {
            result = new ArrayList<VradiSendingDTO>();
            try {
                result = this.getVradiStorageService().getFormsByClients((String)ui.getCriteria().getDateTypeSelection().getSelectedItem(), ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(), (WikittyExtension)ui.getCriteria().getFormTypeSelection().getSelectedItem(), ui.getReceptionProofCheckBox().isSelected() ? (Boolean)ui.getReceptionProofGroup().getSelectedValue() : null, ui.getParagraphCheckBox().isSelected() ? (Boolean)ui.getParagraphGroup().getSelectedValue() : null, ui.getStatusCheckBox().isSelected() ? ((SendingStatus)ui.getStatusComboBox().getSelectedItem()).getStatus() : -1);
            }
            catch (TechnicalException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)e);
            }
        }
        return result;
    }

    Map<Form, List<Client>> getClientsByForms(EmailListByFormUI ui) {
        Map<Object, List<Object>> result;
        block3: {
            result = new HashMap<Form, List<Client>>();
            try {
                result = this.getVradiStorageService().getClientsByForms((String)ui.getCriteria().getDateTypeSelection().getSelectedItem(), ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(), (WikittyExtension)ui.getCriteria().getFormTypeSelection().getSelectedItem());
            }
            catch (TechnicalException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            log.debug((Object)(entry.getKey() + " : " + entry.getValue()));
        }
        return result;
    }

    public void bindEmailsWithForms() {
        block2: {
            try {
                this.getVradiStorageService().bindFormsToClients();
            }
            catch (TechnicalException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientEmailContentTableModel(EmailListByClientUI ui) {
        ClientEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        try {
            contentModel.clear();
            int maxForms = 0;
            for (VradiSendingDTO sendingDTO : this.getFormsByClients(ui)) {
                maxForms = Math.max(maxForms, sendingDTO.getFormDTOs().size());
                contentModel.addEntry(sendingDTO);
            }
            ui.getContent().setRowHeight(maxForms > 1 ? 19 * maxForms : 19);
        }
        finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)0, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value == null) {
                    return super.getTableCellRendererComponent(table, I18n._((String)"vradi.email.session.value.null"), isSelected, hasFocus, row, column);
                }
                return super.getTableCellRendererComponent(table, I18n._((String)"vradi.email.session.value", (Object[])new Object[]{(Date)value}), isSelected, hasFocus, row, column);
            }
        });
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)1, (TableCellRenderer)ui.getContent().getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)2, (TableCellRenderer)new FormListCellRenderer(contentModel));
        SwingUtil.setTableColumnEditor((JTable)ui.getContent(), (int)2, (TableCellEditor)new FormListCellEditor(contentModel));
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)3, (TableCellRenderer)new ParagraphCellRenderer());
        SwingUtil.setTableColumnEditor((JTable)ui.getContent(), (int)3, (TableCellEditor)new ParagraphCellEditor());
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)4, (TableCellRenderer)ui.getContent().getDefaultRenderer(String.class));
        SwingUtil.setTableColumnRenderer((JTable)ui.getContent(), (int)5, (TableCellRenderer)new ReceptionProofRenderer());
        SwingUtil.setTableColumnEditor((JTable)ui.getContent(), (int)5, (TableCellEditor)new DefaultCellEditor(new JCheckBox()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFormEmailContentTableModel(EmailListByFormUI ui) {
        FormEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        try {
            contentModel.clear();
            int maxClients = 0;
            for (Map.Entry<Form, List<Client>> entry : this.getClientsByForms(ui).entrySet()) {
                List<Client> clients = entry.getValue();
                maxClients = Math.max(maxClients, clients.size());
                Form form = entry.getKey();
                contentModel.addEntry(form.getName(), clients);
            }
            ui.getContent().setRowHeight(maxClients > 1 ? 19 * maxClients : 19);
        }
        finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

    public void sendEmails(EmailListByClientUI ui) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Send email");
            }
            ClientEmailContentTableModel contentModel = ui.getContentModel();
            ArrayList<Object> sendingsToSave = new ArrayList<Object>();
            for (VradiSendingDTO sendingDTO : contentModel.getData()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Client : " + sendingDTO.getClientDTO().getName()));
                }
                if (sendingDTO.getStatus() != SendingStatus.TO_SEND.getStatus()) continue;
                sendingDTO.setStatus(sendingDTO.getReceptionProof() ? SendingStatus.WAITING_RECPETION_PROOF.getStatus() : SendingStatus.SENT.getStatus());
                sendingDTO.setSentDate(new Date());
                if (contentModel.getFormsToExclude(sendingDTO) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("No form is excluded, send all to client : " + sendingDTO.getClientDTO().getName()));
                    }
                    sendingsToSave.add(sendingDTO.getSending());
                    continue;
                }
                if (contentModel.getFormsToExclude(sendingDTO).size() == sendingDTO.getFormDTOs().size()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("All the forms are excluded, do nothing for client : " + sendingDTO.getClientDTO().getName()));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Some forms are excluded for client : " + sendingDTO.getClientDTO().getName()));
                }
                SendingImpl newSending = new SendingImpl();
                newSending.setStatus(SendingStatus.TO_SEND.getStatus());
                VradiClientDTO client = sendingDTO.getClientDTO();
                newSending.setClient(client.getWikittyId());
                List<VradiFormDTO> forms = contentModel.getFormsToExclude(sendingDTO);
                for (VradiFormDTO form : forms) {
                    newSending.addForm(form.getWikittyId());
                    sendingDTO.removeFormDTO(form);
                }
                sendingsToSave.add(newSending);
                sendingsToSave.add(sendingDTO.getSending());
            }
            try {
                this.getVradiStorageService().updateSendings(sendingsToSave);
            }
            catch (TechnicalException e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)e);
            }
        }
    }

    public class ActionButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JButton button = new JButton();

        public ActionButtonCellEditor() {
            this.button.setIcon(SwingUtil.getUIManagerActionIcon((String)"send"));
            this.button.setToolTipText("vradi.email.send");
            this.button.setFocusable(false);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    log.debug((Object)"send email");
                    ActionButtonCellEditor.this.fireEditingCanceled();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            return true;
        }

        @Override
        public void cancelCellEditing() {
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }
    }

    public class ActionButtonRenderer
    extends JButton
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (((Boolean)value).booleanValue()) {
                this.setIcon(SwingUtil.getUIManagerActionIcon((String)"send"));
                this.setToolTipText("vradi.email.send");
            } else {
                this.setEnabled(false);
                this.setVisible(false);
            }
            return this;
        }
    }

    public class ReceptionProofRenderer
    extends JCheckBox
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setSelected((Boolean)value);
            return this;
        }
    }

    public class ParagraphCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JPanel panel = new JPanel(new BorderLayout());
        protected JLabel valueLabel = new JLabel();

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.panel.removeAll();
            final String paragraph = value.equals("null") ? "" : (String)value;
            this.valueLabel = new JLabel("<html>" + paragraph.replace("\n", "<br/>") + "</html>");
            this.panel.add((Component)this.valueLabel, "Center");
            JButton button = new JButton();
            button.setIcon(SwingUtil.getUIManagerActionIcon((String)"rename"));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParagraphEditorDialog editor = new ParagraphEditorDialog();
                    editor.setParagraph(paragraph);
                    editor.setVisible(true);
                    ParagraphCellEditor.this.valueLabel.setText("<html>" + editor.getParagraph().replace("\n", "<br/>") + "</html>");
                }
            });
            this.panel.add((Component)button, "Last");
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.valueLabel.getText();
        }
    }

    public class ParagraphCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = "null".equals(value) ? "" : (String)value;
            return super.getTableCellRendererComponent(table, stringValue, isSelected, hasFocus, row, column);
        }
    }

    public class ClientListCellRenderer
    extends JList
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            ArrayList values = new ArrayList((Set)value);
            String[] clientNames = new String[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                clientNames[i] = ((Client)values.get(i)).getName();
            }
            this.setListData(clientNames);
            return this;
        }
    }

    public class FormListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected JList[] lists;
        protected TableCellEditor delegate;
        protected int selectedIndex;

        public FormListCellEditor(TableCellEditor delegate, ClientEmailContentTableModel model) {
            this.delegate = delegate;
            this.lists = new JList[model.getRowCount()];
            for (int i = 0; i < model.getRowCount(); ++i) {
                this.lists[i] = new JList(new DefaultListModel());
                UIHelper.fillList((JList)this.lists[i], (Collection)model.getData().get(i).getFormDTOs(), null);
                OneClicListSelectionModel selectModel = new OneClicListSelectionModel(this.lists[i].getSelectionModel(), this.lists[i].getModel());
                this.lists[i].setSelectionModel((ListSelectionModel)selectModel);
                this.lists[i].setBorder(BorderFactory.createLoweredBevelBorder());
            }
        }

        public FormListCellEditor(ClientEmailContentTableModel model) {
            this(new DefaultCellEditor(new JTextField()), model);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            boolean b = super.isCellEditable(e);
            return b &= ((Component)e.getSource()).hasFocus();
        }

        @Override
        public Object getCellEditorValue() {
            Object[] values = this.lists[this.selectedIndex].getSelectedValues();
            if (log.isDebugEnabled()) {
                log.debug((Object)("selected values = " + Arrays.toString(values)));
            }
            return values;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("editor value" + value));
            }
            this.selectedIndex = row;
            UIHelper.updateListSelection(this.lists[row], value);
            this.lists[row].setFont(table.getFont());
            return this.lists[row];
        }
    }

    public class FormListCellRenderer
    implements TableCellRenderer {
        protected JList[] lists;
        protected TableCellRenderer delegateRenderer;

        public FormListCellRenderer(ClientEmailContentTableModel model) {
            this(new DefaultTableCellRenderer(), model);
        }

        public FormListCellRenderer(TableCellRenderer delegateRenderer, ClientEmailContentTableModel model) {
            this.delegateRenderer = delegateRenderer;
            this.lists = new JList[model.getRowCount()];
            for (int i = 0; i < model.getRowCount(); ++i) {
                this.lists[i] = new JList(new DefaultListModel());
                UIHelper.fillList((JList)this.lists[i], (Collection)model.getData().get(i).getFormDTOs(), null);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("renderer value" + value));
            }
            UIHelper.updateListSelection(this.lists[row], value);
            this.renderFromDelegate(table, value, isSelected, hasFocus, row, column);
            return this.lists[row];
        }

        protected void renderFromDelegate(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent rendererComponent = (JComponent)this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.lists[row].setBackground(rendererComponent.getBackground());
            this.lists[row].setFont(rendererComponent.getFont());
            this.lists[row].setBorder(rendererComponent.getBorder());
        }
    }
}

