/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui;

import com.jurismarches.vradi.VradiHelper;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChangeLogHandler {
    private static Log log = LogFactory.getLog(ChangeLogHandler.class);
    public static final String CHANGELOG_FILE = "com/jurismarches/vradi/changelog.txt";
    public static final String CHANGELOG_VERSION_SEPARATOR = "\n---- ";

    public String getLatestChangeLog() {
        String content = this.loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        log.debug((Object)versionChangeLogs[0]);
        String lastVersion = versionChangeLogs[0].replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "").split("\\s")[0].trim();
        log.debug((Object)lastVersion);
        return versionChangeLogs[0];
    }

    public String getChangeLog() {
        StringBuffer result = new StringBuffer();
        String content = this.loadSource();
        String[] versionChangeLogs = content.split(CHANGELOG_VERSION_SEPARATOR);
        log.debug((Object)versionChangeLogs[0]);
        String lastVersion = versionChangeLogs[0].replace(CHANGELOG_VERSION_SEPARATOR.substring(1), "").split("\\s")[0].trim();
        log.debug((Object)lastVersion);
        if (VradiHelper.isVersionNewer(lastVersion)) {
            result.append(versionChangeLogs[0]);
            for (int i = 1; i < versionChangeLogs.length; ++i) {
                log.debug((Object)versionChangeLogs[i]);
                String version = versionChangeLogs[i].split("\\s")[0].trim();
                if (!VradiHelper.isVersionNewer(version)) break;
                result.append(CHANGELOG_VERSION_SEPARATOR).append(versionChangeLogs[i]);
            }
        }
        VradiHelper.setLastVersion(lastVersion);
        return result.toString();
    }

    public String loadSource() {
        try {
            InputStream changelogFile = this.getClass().getClassLoader().getResourceAsStream(CHANGELOG_FILE);
            String result = IOUtils.toString((InputStream)changelogFile);
            log.debug((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)"could not load file com/jurismarches/vradi/changelog.txt", (Throwable)e);
            return "could not load file com/jurismarches/vradi/changelog.txt";
        }
    }
}

