/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.PrefixAwareTokenFilter;

public class PrefixAndSuffixAwareTokenFilter
extends TokenStream {
    private PrefixAwareTokenFilter suffix;

    public PrefixAndSuffixAwareTokenFilter(TokenStream prefix, TokenStream input, TokenStream suffix) {
        prefix = new PrefixAwareTokenFilter(prefix, input){

            public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
                return PrefixAndSuffixAwareTokenFilter.this.updateInputToken(suffixToken, lastInputToken);
            }
        };
        this.suffix = new PrefixAwareTokenFilter(prefix, suffix){

            public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
                return PrefixAndSuffixAwareTokenFilter.this.updateSuffixToken(suffixToken, lastInputToken);
            }
        };
    }

    public Token updateInputToken(Token inputToken, Token lastPrefixToken) {
        inputToken.setStartOffset(lastPrefixToken.endOffset() + inputToken.startOffset());
        inputToken.setEndOffset(lastPrefixToken.endOffset() + inputToken.endOffset());
        return inputToken;
    }

    public Token updateSuffixToken(Token suffixToken, Token lastInputToken) {
        suffixToken.setStartOffset(lastInputToken.endOffset() + suffixToken.startOffset());
        suffixToken.setEndOffset(lastInputToken.endOffset() + suffixToken.endOffset());
        return suffixToken;
    }

    public Token next(Token reusableToken) throws IOException {
        assert (reusableToken != null);
        return this.suffix.next(reusableToken);
    }

    public void reset() throws IOException {
        this.suffix.reset();
    }

    public void close() throws IOException {
        this.suffix.close();
    }
}

