/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.UpdateResponse;
import org.sharengo.wikitty.Wikitty;
import org.sharengo.wikitty.WikittyException;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyExtensionStorage;
import org.sharengo.wikitty.WikittyStorage;
import org.sharengo.wikitty.WikittyTransaction;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyJDBCUtil;

public class WikittyStorageJDBC
implements WikittyStorage {
    protected static Log log = LogFactory.getLog(WikittyStorageJDBC.class);
    protected static String driver = "jdbc.con.driver";
    protected static String wikittyAdminCreationQ = "jdbc.queries.creation.wikitty.admin";
    protected static String wikittyDataCreationQ = "jdbc.queries.creation.wikitty.data";
    protected static String selectionQ = "jdbc.queries.select";
    protected static String whereSelectionQ = "jdbc.queries.select.where";
    protected static String notDeletedWhereSelectionQ = "jdbc.queries.select.where.notdeleted";
    protected static String adminInsertQ = "jdbc.queries.insert.wikitty.admin";
    protected static String adminUpdateQ = "jdbc.queries.update.wikitty.admin";
    protected static String dataInsertQ = "jdbc.queries.insert.wikitty.data";
    protected static String adminDeletionQ = "jdbc.queries.delete.wikitty.admin";
    protected static String dataDeletionQ = "jdbc.queries.delete.wikitty.data";
    protected static String adminTable = "wikitty_admin";
    protected static String dataTable = "wikitty_data";
    protected Properties conf = WikittyJDBCUtil.loadProperties();
    private static final Pattern listFieldPattern = Pattern.compile("(.*)\\[(\\d+)/(\\d+)\\]");
    protected WikittyExtensionStorage extensionStorage;

    public WikittyStorageJDBC(WikittyExtensionStorage extensionStorage) {
        this.extensionStorage = extensionStorage;
        try {
            Class.forName(this.conf.getProperty(driver));
        }
        catch (ClassNotFoundException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't find the driver!");
                eee.printStackTrace();
            }
            throw new WikittyException((Exception)eee);
        }
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            try {
                statement.execute(this.conf.getProperty(wikittyAdminCreationQ));
                statement.execute(this.conf.getProperty(wikittyDataCreationQ));
                con.commit();
            }
            catch (SQLException eee) {
                con.rollback();
            }
            WikittyJDBCUtil.closeConnection(con);
        }
        catch (SQLException eee) {
            if (log.isFatalEnabled()) {
                log.fatal((Object)"Couldn't connect !");
                eee.printStackTrace();
            }
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public List<WikittyStorage.Command> prepare(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) throws WikittyException {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            ArrayList<WikittyStorage.Command> result = new ArrayList<WikittyStorage.Command>(wikitties.size());
            for (Wikitty wikitty : wikitties) {
                Statement statement = con.createStatement();
                ResultSet versionResultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "version", adminTable, "id", "'" + wikitty.getId() + "'"));
                StringBuffer batch = new StringBuffer();
                String version = null;
                String newVersion = null;
                String extensionList = "";
                boolean wikittyAlreadyExists = versionResultSet.first();
                if (wikittyAlreadyExists) {
                    String wVersion;
                    version = versionResultSet.getString("version");
                    if (WikittyUtil.versionEquals((String)version, (String)(wVersion = wikitty.getVersion()))) continue;
                    if (WikittyUtil.versionGreaterThan((String)version, (String)wVersion)) {
                        throw new WikittyException(String.format("Your wikitty '%s' is obsolete", wikitty.getId()));
                    }
                    newVersion = WikittyUtil.incrementMajorRevision((String)wVersion);
                } else {
                    newVersion = WikittyUtil.incrementMajorRevision(version);
                }
                batch.append(String.format(this.conf.getProperty(dataDeletionQ), wikitty.getId()));
                for (WikittyExtension ext : wikitty.getExtensions()) {
                    extensionList = extensionList + "," + ext.getId();
                    block20: for (String fieldName : ext.getFieldNames()) {
                        Object objectValue;
                        FieldType type = ext.getFieldType(fieldName);
                        if (type.isCollection()) {
                            List list = wikitty.getFieldAsList(ext.getName(), fieldName, Object.class);
                            if (list != null) {
                                switch (type.getType()) {
                                    case BOOLEAN: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (Boolean)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "booleanValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", ((Boolean)value).toString()));
                                        }
                                        continue block20;
                                    }
                                    case DATE: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (Date)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "dateValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", "'" + new Timestamp(((Date)value).getTime()) + "'"));
                                        }
                                        continue block20;
                                    }
                                    case NUMERIC: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (BigDecimal)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "numberValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", ((BigDecimal)value).toString()));
                                        }
                                        continue block20;
                                    }
                                    case STRING: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (String)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", "'" + ((String)value).replace("'", "''") + "'"));
                                        }
                                        continue block20;
                                    }
                                    case WIKITTY: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (String)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", "'" + (String)value + "'"));
                                        }
                                        continue block20;
                                    }
                                    default: {
                                        Object value;
                                        for (int i = 0; i < list.size(); ++i) {
                                            value = (String)list.get(i);
                                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName + "[" + i + "/" + list.size() + "]", "'" + ((String)value).replace("'", "''") + "'"));
                                        }
                                        continue block20;
                                    }
                                }
                            }
                            if (!type.isNotNull()) continue;
                            throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                        }
                        switch (type.getType()) {
                            case BOOLEAN: {
                                Boolean booleanValue = wikitty.getFieldAsBoolean(ext.getName(), fieldName);
                                if (booleanValue != null) {
                                    batch.append(String.format(this.conf.getProperty(dataInsertQ), "booleanValue", wikitty.getId(), ext.getName(), fieldName, booleanValue.toString()));
                                    continue block20;
                                }
                                System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                                if (!type.isNotNull()) continue block20;
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                            case DATE: {
                                Date dateValue = wikitty.getFieldAsDate(ext.getName(), fieldName);
                                if (dateValue != null) {
                                    batch.append(String.format(this.conf.getProperty(dataInsertQ), "dateValue", wikitty.getId(), ext.getName(), fieldName, "'" + new Timestamp(dateValue.getTime()) + "'"));
                                    continue block20;
                                }
                                System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                                if (!type.isNotNull()) continue block20;
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                            case NUMERIC: {
                                Double numberValue = wikitty.getFieldAsDouble(ext.getName(), fieldName);
                                if (numberValue != null) {
                                    batch.append(String.format(this.conf.getProperty(dataInsertQ), "numberValue", wikitty.getId(), ext.getName(), fieldName, numberValue.toString()));
                                    continue block20;
                                }
                                System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                                if (!type.isNotNull()) continue block20;
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                            case STRING: {
                                String stringValue = wikitty.getFieldAsString(ext.getName(), fieldName);
                                if (stringValue != null) {
                                    batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName, "'" + stringValue.replace("'", "''") + "'"));
                                    continue block20;
                                }
                                System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                                if (!type.isNotNull()) continue block20;
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                            case WIKITTY: {
                                objectValue = wikitty.getFieldAsObject(ext.getName(), fieldName);
                                if (objectValue != null) {
                                    batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName, "'" + objectValue.toString().replace("'", "''") + "'"));
                                    continue block20;
                                }
                                System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                                if (!type.isNotNull()) continue block20;
                                throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                            }
                        }
                        objectValue = wikitty.getFieldAsObject(ext.getName(), fieldName);
                        if (objectValue != null) {
                            batch.append(String.format(this.conf.getProperty(dataInsertQ), "textValue", wikitty.getId(), ext.getName(), fieldName, "'" + objectValue.toString().replace("'", "''") + "'"));
                            continue;
                        }
                        System.out.println("#####DEBUG####" + type.toDefinition(fieldName));
                        if (!type.isNotNull()) continue;
                        throw new WikittyException(String.format("Field %s in extension %s can't be null", fieldName, ext.getName()));
                    }
                }
                if (extensionList.length() > 0) {
                    extensionList = extensionList.substring(1);
                }
                if (wikittyAlreadyExists) {
                    String update = String.format(this.conf.getProperty(adminUpdateQ), newVersion, extensionList, wikitty.getId());
                    batch.insert(0, update);
                } else {
                    String insert = String.format(this.conf.getProperty(adminInsertQ), wikitty.getId(), newVersion, extensionList);
                    batch.insert(0, insert);
                }
                CommandJDBC command = new CommandJDBC(batch.toString(), wikitty, newVersion);
                result.add(command);
            }
            return result;
        }
        catch (SQLException eee) {
            try {
                con.rollback();
            }
            catch (SQLException eeee) {
                eeee.printStackTrace();
            }
            throw new WikittyException((Exception)eee);
        }
    }

    public UpdateResponse commit(WikittyTransaction transaction, List<WikittyStorage.Command> wikittyStorageCommandList) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            UpdateResponse result = new UpdateResponse();
            for (WikittyStorage.Command command : wikittyStorageCommandList) {
                CommandJDBC commandJDBC = (CommandJDBC)command;
                statement.execute(commandJDBC.queries);
                if (commandJDBC.toStore) {
                    Wikitty wikitty = commandJDBC.wikitty;
                    String newVersion = commandJDBC.version;
                    wikitty.setVersion(newVersion);
                    wikitty.clearDirty();
                    result.addVersionUpdate(wikitty.getId(), newVersion);
                    continue;
                }
                String id = commandJDBC.id;
                Date date = commandJDBC.date;
                result.addDeletionDateUpdate(id, date);
            }
            con.commit();
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con, true);
            throw new WikittyException((Exception)eee);
        }
    }

    public boolean exists(String id) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "id", adminTable, "id", "'" + id + "'"));
            boolean result = resultSet.first();
            WikittyJDBCUtil.closeConnection(con);
            return result;
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public boolean isDeleted(String id) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            ResultSet resultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "deletionDate", adminTable, "id", "'" + id + "'"));
            if (resultSet.first()) {
                boolean result = resultSet.getDate("deletionDate") != null;
                WikittyJDBCUtil.closeConnection(con);
                return result;
            }
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException(String.format("Wikitty with id '%s' doesn't exists", id));
        }
        catch (SQLException eee) {
            WikittyJDBCUtil.closeConnection(con);
            throw new WikittyException((Exception)eee);
        }
    }

    public Wikitty restore(String id, String ... fqFieldName) throws WikittyException {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            ResultSet adminResultSet = statement.executeQuery(String.format(this.conf.getProperty(notDeletedWhereSelectionQ), "*", adminTable, "id", "'" + id + "'"));
            if (adminResultSet.first()) {
                String version = adminResultSet.getString("version");
                String extensionList = adminResultSet.getString("extension_list");
                ResultSet dataResultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "*", dataTable, "id", "'" + id + "'"));
                Wikitty result = this.constructWikitty(id, version, extensionList, dataResultSet, fqFieldName);
                return result;
            }
            throw new WikittyException(String.format("Can't restore wikitty '%s'", id));
        }
        catch (Exception eee) {
            throw new WikittyException(String.format("Can't restore wikitty '%s'", id), eee);
        }
    }

    public List<Wikitty> restore(Collection<String> ids, String ... fqFieldName) throws WikittyException {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>(ids.size());
        for (String id : ids) {
            Wikitty w = this.restore(id, fqFieldName);
            result.add(w);
        }
        return result;
    }

    public List<WikittyStorage.Command> delete(List<String> ids) throws WikittyException {
        try {
            ArrayList<WikittyStorage.Command> result = new ArrayList<WikittyStorage.Command>(ids.size());
            Date now = new Date();
            for (String id : ids) {
                if (!this.exists(id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' doesn't exists", id));
                }
                if (this.isDeleted(id)) {
                    throw new WikittyException(String.format("Wikitty with id '%s' is already deleted", id));
                }
                StringBuffer batch = new StringBuffer();
                batch.append(String.format(this.conf.getProperty(adminDeletionQ), id));
                result.add(new CommandJDBC(batch.toString(), id, now));
            }
            return result;
        }
        catch (Exception eee) {
            throw new WikittyException(eee);
        }
    }

    protected Wikitty constructWikitty(String id, String version, String extensionList, ResultSet resultSet, String ... fqFieldName) throws Exception {
        HashSet<String> acceptedField = new HashSet<String>(Arrays.asList(fqFieldName));
        Wikitty result = new Wikitty(id);
        result.setVersion(version);
        if (extensionList != null && !"".equals(extensionList)) {
            for (String ext : extensionList.split(",")) {
                WikittyExtension extension = this.extensionStorage.restore(WikittyExtension.computeName((String)ext), WikittyExtension.computeVersion((String)ext));
                result.addExtension(extension);
            }
        }
        HashMap<String, Object[]> listFieldMap = new HashMap<String, Object[]>();
        resultSet.beforeFirst();
        while (resultSet.next()) {
            String fqfieldName = resultSet.getString("fieldName");
            if (!this.isAcceptedField(acceptedField, fqfieldName)) continue;
            FieldType type = result.getFieldType(fqfieldName);
            Object value = null;
            switch (type.getType()) {
                case BOOLEAN: {
                    value = resultSet.getBoolean("booleanValue");
                    break;
                }
                case DATE: {
                    value = new Date(resultSet.getTimestamp("dateValue").getTime());
                    break;
                }
                case NUMERIC: {
                    value = resultSet.getBigDecimal("numberValue");
                    break;
                }
                case STRING: {
                    value = resultSet.getString("textValue");
                    break;
                }
                case WIKITTY: {
                    value = resultSet.getString("textValue");
                    break;
                }
                default: {
                    value = resultSet.getString("textValue");
                }
            }
            if (type.isCollection()) {
                Matcher match = listFieldPattern.matcher(fqfieldName);
                if (match.find()) {
                    fqfieldName = match.group(1);
                    int index = Integer.parseInt(match.group(2));
                    Object[] array = (Object[])listFieldMap.get(fqfieldName);
                    if (array == null) {
                        int size = Integer.parseInt(match.group(3));
                        array = new Object[size];
                        listFieldMap.put(fqfieldName, array);
                    }
                    array[index] = value;
                    continue;
                }
                if (!log.isErrorEnabled()) continue;
                log.error((Object)String.format("Can't read list field correctly '%s'", fqfieldName));
                continue;
            }
            result.setFqField(fqfieldName, value);
        }
        for (String fieldName : listFieldMap.keySet()) {
            Object[] array = (Object[])listFieldMap.get(fieldName);
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array));
            result.setFqField(fieldName, list);
        }
        return result;
    }

    protected boolean isAcceptedField(Set<String> acceptedField, String fqfieldName) {
        boolean result = acceptedField.isEmpty();
        if (!result) {
            int crochet = fqfieldName.indexOf("[");
            if (crochet != -1) {
                fqfieldName = fqfieldName.substring(0, crochet);
            }
            result = acceptedField.contains(fqfieldName);
        }
        return result;
    }

    public void scanWikitties(WikittyStorage.Scanner scanner) {
        Connection con = null;
        try {
            con = WikittyJDBCUtil.getConnection();
            Statement statement = con.createStatement();
            ResultSet adminResultSet = statement.executeQuery(String.format(this.conf.getProperty(selectionQ), "*", adminTable));
            adminResultSet.beforeFirst();
            while (adminResultSet.next()) {
                String id = adminResultSet.getString("id");
                String version = adminResultSet.getString("version");
                String extensionList = adminResultSet.getString("extension_list");
                ResultSet dataResultSet = statement.executeQuery(String.format(this.conf.getProperty(whereSelectionQ), "*", dataTable, "id", "'" + id + "'"));
                Wikitty result = this.constructWikitty(id, version, extensionList, dataResultSet, new String[0]);
                scanner.scan(result);
            }
        }
        catch (Exception eee) {
            throw new WikittyException("Can't restore wikitties", eee);
        }
    }

    class CommandJDBC
    implements WikittyStorage.Command {
        protected boolean toStore;
        protected Wikitty wikitty;
        protected String queries;
        protected String version;
        protected String id;
        protected Date date;

        public CommandJDBC(String queries, Wikitty wikitty, String version) {
            this.queries = queries;
            this.toStore = true;
            this.wikitty = wikitty;
            this.version = version;
        }

        public CommandJDBC(String queries, String id, Date date) {
            this.queries = queries;
            this.toStore = false;
            this.id = id;
            this.date = date;
        }
    }
}

