/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jdbc;

import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WikittyJDBCUtil {
    private static Log log = LogFactory.getLog(WikittyJDBCUtil.class);
    public static final String COL_EXTENSION = "extension_list";
    public static final String COL_REQUIRES = "requires";
    public static final String COL_TAG_VALUES = "tagValues";
    public static final String COL_VERSION = "version";
    public static final String COL_ID = "id";
    public static final String COL_NAME = "name";
    public static final String COL_FIELDNAME = "fieldName";
    public static final String COL_FIELDTYPE = "fieldType";
    public static final String COL_FIELDRANK = "fieldRank";
    public static final String COL_BOOLEAN_VALUE = "booleanValue";
    public static final String COL_NUMBER_VALUE = "numberValue";
    public static final String COL_TEXT_VALUE = "textValue";
    public static final String COL_DATE_VALUE = "dateValue";
    public static final String COL_DELETION_DATE = "deletionDate";
    protected static String host = "jdbc.con.host";
    protected static String userName = "jdbc.con.userName";
    protected static String password = "jdbc.con.password";
    protected static Properties conf = WikittyJDBCUtil.loadProperties();
    public static final String CONFIG_FILE = "jdbc.properties";

    public static Properties loadProperties() {
        Properties properties;
        block2: {
            properties = new Properties();
            try {
                URL url = WikittyJDBCUtil.class.getClassLoader().getResource(CONFIG_FILE);
                properties.load(url.openStream());
            }
            catch (Exception eee) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Unable to load property file jdbc.properties for reason " + eee.getMessage()), (Throwable)eee);
            }
        }
        return properties;
    }

    public static Connection getConnection() throws SQLException {
        Connection con = DriverManager.getConnection(conf.getProperty(host), conf.getProperty(userName), conf.getProperty(password));
        con.setAutoCommit(false);
        return con;
    }

    public static void closeConnection(Connection con) {
        WikittyJDBCUtil.closeConnection(con, false);
    }

    public static void closeConnection(Connection con, boolean rollBack) {
        block4: {
            try {
                if (con != null) {
                    if (rollBack) {
                        con.rollback();
                    }
                    con.close();
                }
            }
            catch (SQLException eee) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)eee);
            }
        }
    }
}

