/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.dto.VradiThesaurusDTO;
import com.jurismarches.vradi.ui.OfferListTableModel;
import com.jurismarches.vradi.ui.OfferListUI;
import com.jurismarches.vradi.ui.UIHelper;
import com.jurismarches.vradi.ui.search.CriteriaField;
import com.jurismarches.vradi.ui.search.CriteriaUI;
import com.jurismarches.vradi.ui.search.SearchUI;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public class SearchHandler {
    private static final Log log = LogFactory.getLog(SearchHandler.class);
    public static final String CSV_FILE_EXTENSION = ".csv";

    public SearchUI initUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        SearchUI ui = this.getUI(rootContext);
        if (ui == null) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            context.add((Object)this);
            context.add((Object)resultTableModel);
            ui = new SearchUI((JAXXContext)context);
            this.initCriteria((JAXXContext)ui);
            VradiContext.SEARCH_UI_ENTRY_DEF.setContextValue(rootContext, (Object)ui);
        }
        return ui;
    }

    public SearchUI initCloneUI(JAXXContext rootContext, OfferListTableModel resultTableModel) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
        context.add((Object)this);
        context.add((Object)resultTableModel);
        SearchUI ui = new SearchUI((JAXXContext)context);
        this.initCriteria((JAXXContext)ui);
        return ui;
    }

    SearchUI getUI(JAXXContext context) {
        if (context instanceof SearchUI) {
            return (SearchUI)context;
        }
        SearchUI ui = (SearchUI)((Object)VradiContext.SEARCH_UI_ENTRY_DEF.getContextValue(context));
        return ui;
    }

    public ComboBoxModel getRequestModel() {
        return new DefaultComboBoxModel();
    }

    public void executeQuery(JAXXContext context) {
        SearchUI ui = this.getUI(context);
        if (ui != null) {
            String query = ui.getRequest().trim();
            OfferListTableModel listTableModel = ui.getResultTableModel();
            log.debug((Object)(listTableModel.getNbFormsPerPage() + " - " + listTableModel.getPageToShow()));
            JComboBox combo = ui.isOfferListUI() != false ? ui.getRequests() : null;
            CriteriaUI criterias = ui.getCriterias().isVisible() ? ui.getCriterias() : null;
            log.debug((Object)(criterias == null ? 1 : 0));
            this.executeQuery((JAXXContext)ui, criterias, listTableModel, combo, query);
        }
    }

    public List<String> loadRequests() {
        return VradiHelper.loadRequests();
    }

    public JPanel getCriteriaPanel(JAXXContext context) {
        return this.getUI(context).getCriterias().getCriteriaPanel();
    }

    public CriteriaUI getCriterias(JAXXContext context) {
        return this.getUI(context).getCriterias();
    }

    public void initCriteria(JAXXContext context) {
        this.getCriteriaPanel(context).removeAll();
        TreeNode root = null;
        try {
            root = ServiceHelper.getVradiStorageService().getRootThesaurus();
        }
        catch (TechnicalException e) {
            log.error((Object)"Cant get rootThesaurus : ", (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        this.addCriteria(context, root, false);
        for (String value : VradiHelper.getVradiListCriteria()) {
            this.addCriteria(context, value, true);
        }
    }

    public void removeCriteria(JAXXContext context, CriteriaField criteriaField) {
        this.getCriteriaPanel(context).remove((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    public void removeCriteriaAndPersist(JAXXContext context, TreeNode bean) {
        CriteriaField criteriaField = (CriteriaField)context;
        VradiHelper.removeVradiListCriteria(bean);
        this.removeCriteria(context, criteriaField);
        this.getUI(context).validate();
    }

    public void addAndPersistCriteria(JAXXContext context, TreeNode node) {
        VradiHelper.addVradiListCriteria(node);
        this.addCriteria(context, node, true);
    }

    protected void addCriteria(JAXXContext context, String wikittyId, boolean deletable) {
        TreeNode criteria = null;
        try {
            criteria = ServiceHelper.getVradiStorageService().getThesaurus(wikittyId);
        }
        catch (TechnicalException e) {
            log.error((Object)("Cant get thesaurus : " + wikittyId), (Throwable)e);
            ErrorDialogUI.showError((Exception)e);
        }
        if (criteria != null) {
            this.addCriteria(context, criteria, deletable);
        }
    }

    protected void addCriteria(JAXXContext context, TreeNode criteria, boolean deletable) {
        VradiThesaurusDTO thesCriteria = new VradiThesaurusDTO();
        thesCriteria.fromWikitty(criteria);
        CriteriaField criteriaField = new CriteriaField(context);
        criteriaField.setLabelName(criteria.getName());
        criteriaField.setBean(criteria);
        criteriaField.setDeletable(deletable);
        JComboBox combo = criteriaField.getCombo();
        VradiThesaurusDTO[] thesArray = new VradiThesaurusDTO[thesCriteria.getChildren().size() + 1];
        for (int i = 1; i < thesArray.length; ++i) {
            thesArray[i] = (VradiThesaurusDTO)thesCriteria.getChildren().toArray()[i - 1];
        }
        combo.setModel(new DefaultComboBoxModel<VradiThesaurusDTO>(thesArray));
        combo.setRenderer(VradiContext.get().getDecoratorProviderListCellRenderer());
        criteriaField.init();
        this.getCriteriaPanel(context).add((Component)((Object)criteriaField));
        this.getUI(context).validate();
    }

    protected List<String> getDateFormType(WikittyExtension formType) {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Form.datePub");
        result.add("Form.datePeremption");
        if (formType != null) {
            for (String name : formType.getFieldNames()) {
                FieldType type = formType.getFieldType(name);
                if (type.getType() != FieldType.TYPE.DATE) continue;
                result.add(formType.getName() + "." + name);
            }
        }
        return result;
    }

    public DefaultComboBoxModel updateDateSelectionModel(WikittyExtension selected) {
        List<String> datas = this.getDateFormType(selected);
        return new DefaultComboBoxModel<String>(datas.toArray(new String[datas.size()]));
    }

    public void executeQuery(JAXXContext context, CriteriaUI criterias, OfferListTableModel tableModel, JComboBox combo, String request) {
        String query = request.trim();
        if (criterias == null) {
            VradiHelper.executeQuery(query, null, null, null, null, null, tableModel.getDatas());
        } else {
            Component[] thesaurusCriteria = this.getCriteriaPanel(context).getComponents();
            ArrayList[] thesaurus = new ArrayList[thesaurusCriteria.length];
            for (int i = 0; i < thesaurus.length; ++i) {
                VradiThesaurusDTO th = (VradiThesaurusDTO)((CriteriaField)((Object)thesaurusCriteria[i])).getCombo().getSelectedItem();
                if (th == null) continue;
                thesaurus[i] = new ArrayList();
                thesaurus[i].add(th.getWikittyId());
                VradiHelper.getThesaurusChildren(th, thesaurus[i]);
            }
            GregorianCalendar beginDate = new GregorianCalendar();
            beginDate.setTime(criterias.getFromDate().getDate());
            beginDate.set(11, (Integer)criterias.getFromHour().getSelectedItem());
            beginDate.set(12, (Integer)criterias.getFromMinute().getSelectedItem());
            GregorianCalendar endDate = new GregorianCalendar();
            endDate.setTime(criterias.getToDate().getDate());
            endDate.set(11, (Integer)criterias.getToHour().getSelectedItem());
            endDate.set(12, (Integer)criterias.getToMinute().getSelectedItem());
            VradiHelper.executeQuery(query, (WikittyExtension)criterias.getFormTypeSelection().getSelectedItem(), (String)criterias.getDateTypeSelection().getSelectedItem(), beginDate.getTime(), endDate.getTime(), thesaurus, tableModel.getDatas());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Form found : " + tableModel.getDatas().getTotalFoundFormNb()));
        }
        if (context instanceof OfferListUI) {
            VradiHelper.addRequestToProperties(query);
        }
        if (combo != null) {
            ((DefaultComboBoxModel)combo.getModel()).removeElement(request);
            combo.insertItemAt(request, 0);
            combo.setSelectedIndex(0);
        }
    }

    public ListCellRenderer getDateTypeComboBoxRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String stringValue = null;
                if (value != null) {
                    stringValue = value.toString();
                    stringValue = stringValue.substring(stringValue.indexOf(46) + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, stringValue, index, isSelected, cellHasFocus);
            }
        };
    }

    public void exportToCSV(JAXXContext context) {
        SearchUI ui = this.getUI(context);
        File file = UIHelper.openFileChooser(CSV_FILE_EXTENSION, "vradi.export.filter.csv", (Component)((Object)ui), "vradi.export.validate.label");
        if (file != null) {
            OfferListTableModel completeModel = new OfferListTableModel(new VradiFormPageDTO());
            this.executeQuery(context, ui != null ? ui.getCriterias() : null, completeModel, null, ui != null ? ui.getRequest() : null);
            UIHelper.exportToCSV(file, completeModel);
        }
    }
}

