/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui.email;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.services.ServiceHelper;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiClientDTO;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import com.jurismarches.vradi.services.dto.VradiXmlStreamDTO;
import com.jurismarches.vradi.ui.*;
import com.jurismarches.vradi.ui.admin.AdminPopupUI;
import com.jurismarches.vradi.ui.admin.content.AdminXmlStreamUI;
import com.jurismarches.vradi.ui.admin.content.XmlStreamFieldTableModel;
import com.jurismarches.vradi.ui.editors.JListCellEditor;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.WikittyExtension;

import javax.swing.*;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.util.HashMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.*;
import java.util.List;
import java.util.Map;

/**
 * @author morin
 */
public class EmailHandler implements JAXXAction {

    static private final Log log = LogFactory.getLog(EmailHandler.class);

    @Override
    public JAXXInitialContext init(JAXXContext parentContext, Object... datas) {
        return new JAXXInitialContext().add(parentContext).add(this);
    }


    EmailPopupUI getUI(JAXXContext context) {
        if (context instanceof EmailPopupUI) {
            return (EmailPopupUI) context;
        }
        EmailPopupUI ui = VradiContext.EMAIL_UI_ENTRY_DEF.getContextValue(context);
        return ui;
    }

    void close(JAXXContext context) {
        EmailPopupUI ui = getUI(context);
        ui.setVisible(false);
        ui.dispose();
    }

    protected VradiStorageService getVradiStorageService() {
        return ServiceHelper.getVradiStorageService();
    }

    List<VradiSendingDTO> getFormsByClients(EmailListByClientUI ui) {
        List<VradiSendingDTO> result = new ArrayList<VradiSendingDTO>();
        try {
            result = getVradiStorageService().getFormsByClients(
                    (String) ui.getCriteria().getDateTypeSelection().getSelectedItem(),
                    ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(),
                    (WikittyExtension) ui.getCriteria().getFormTypeSelection().getSelectedItem());
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
        return result;
    }

    Map<Form, List<Client>> getClientsByForms(EmailListByFormUI ui) {
        Map<Form, List<Client>> result = new HashMap<Form, List<Client>>();
        try {
            result = getVradiStorageService().getClientsByForms(
                    (String) ui.getCriteria().getDateTypeSelection().getSelectedItem(),
                    ui.getCriteria().getFromDate().getDate(), ui.getCriteria().getToDate().getDate(),
                    (WikittyExtension) ui.getCriteria().getFormTypeSelection().getSelectedItem()
            );
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
        for (Map.Entry entry : result.entrySet()) {
            log.info(entry.getKey() + " : " + entry.getValue());
        }
        return result;
    }

    public void bindEmailsWithForms() {
        try {
            getVradiStorageService().bindFormsToClients();
        } catch (TechnicalException e) {
            e.printStackTrace();
        }
    }

    public class FormListCellRenderer extends JList implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            // 'value' is value contained in the cell located at
            // (rowIndex, vColIndex)

            // Configure the component with the specified value
            List<Form> values = (List<Form>) value;
            String[] formNames = new String[values.size()];
            for (int i = 0; i < values.size(); i++) {
                formNames[i] = values.get(i).getName();
            }
            setListData(formNames);

            // Since the renderer is a component, return itself
            return this;
        }

        // The following methods override the defaults for performance reasons
        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class ClientListCellRenderer extends JList implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            // 'value' is value contained in the cell located at
            // (rowIndex, vColIndex)

            // Configure the component with the specified value
            List<Client> values = (List<Client>) value;
            String[] clientNames = new String[values.size()];
            for (int i = 0; i < values.size(); i++) {
                clientNames[i] = values.get(i).getName();
            }
            setListData(clientNames);

            // Since the renderer is a component, return itself
            return this;
        }

        // The following methods override the defaults for performance reasons
        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class ClientCellRenderer extends JLabel implements TableCellRenderer {
        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            // 'value' is value contained in the cell located at
            // (rowIndex, vColIndex)

            // Configure the component with the specified value
            VradiClientDTO client = (VradiClientDTO) value;
            setText(client.getName());

            // Since the renderer is a component, return itself
            return this;
        }

        // The following methods override the defaults for performance reasons
        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    public class ParagraphCellRenderer extends JPanel implements TableCellRenderer {

        protected JAXXContext context = null;

        public ParagraphCellRenderer(JAXXContext context) {
            this.context = context;
        }

        // This method is called each time a cell in a column
        // using this renderer needs to be rendered.
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            // 'value' is value contained in the cell located at
            // (rowIndex, vColIndex)

            // Configure the component with the specified value
            String paragraph = (String) value;
            add(new JTextArea(paragraph));
            JButton edit = new JButton("...");
            edit.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new ParagraphEditorDialog(context).setVisible(true);
                }
            });
            add(new JButton());

            // Since the renderer is a component, return itself
            return this;
        }

        // The following methods override the defaults for performance reasons
        public void validate() {
        }

        public void revalidate() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }


    public void updateClientEmailContentTableModel(EmailListByClientUI ui) {

        ClientEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        try {

            contentModel.clear();

            // ajout des donnees
            int maxForms = 0;

            for (VradiSendingDTO sendingDTO : getFormsByClients(ui)) {
                maxForms = Math.max(maxForms, sendingDTO.getFormDTOs().size());

                contentModel.addEntry(sendingDTO);
            }

            ui.getContent().setRowHeight(maxForms > 1 ? 19 * maxForms : 19);

        } finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

    public void updateFormEmailContentTableModel(EmailListByFormUI ui) {

        FormEmailContentTableModel contentModel = ui.getContentModel();
        contentModel.setValueIsAdjusting(true);
        ui.getContent().getColumnModel().getColumn(1).setCellRenderer(new ClientListCellRenderer());

        try {

            contentModel.clear();

            // ajout des donnees
            int maxClients = 0;

            for (Map.Entry entry : getClientsByForms(ui).entrySet()) {
                maxClients = Math.max(maxClients, ((List<Client>) entry.getValue()).size());
                contentModel.addEntry(((Form) entry.getKey()).getName(), (List<Client>) entry.getValue());
            }

            ui.getContent().setRowHeight(maxClients > 1 ? 19 * maxClients : 19);

        } finally {
            contentModel.fireTableDataChanged();
            contentModel.setValueIsAdjusting(false);
        }
    }

}
