/*
 * *##% 
 * vradi-swing
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.ui;

import jaxx.runtime.swing.renderer.I18nTableCellRenderer;
import static org.nuiton.i18n.I18n._;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import java.awt.*;

/**
 * @author letellier
 */
public class VradiI18nTableCellRenderer extends I18nTableCellRenderer {

    public VradiI18nTableCellRenderer(TableCellRenderer delegate, String... keysAndTips) {
        super(delegate, keysAndTips);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        TableColumn col = table.getColumn(table.getColumnName(column));
        int index = col.getModelIndex();
        if (index < keys.length) {
            value = _(keys[index]);
            JComponent rendererComponent = (JComponent) delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
            rendererComponent.setToolTipText(_(tips[index]));
            return rendererComponent;
        }
        return (JComponent) delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
    }

}
