/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.operators.And;
import org.nuiton.wikitty.search.operators.BinaryOperator;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.search.operators.Restriction;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;
import org.nuiton.wikitty.storage.WikittyStorageInMemory;

public class WikittySearchEngineInMemory
implements WikittySearchEngine {
    WikittyStorageInMemory wikittyStorage;

    public WikittySearchEngineInMemory(WikittyStorageInMemory wikittyStorage) {
        this.wikittyStorage = wikittyStorage;
    }

    @Override
    public void clear(WikittyTransaction transaction) {
    }

    @Override
    public void store(WikittyTransaction transaction, Collection<Wikitty> wikitties) {
    }

    @Override
    public void delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException {
    }

    public boolean checkRestriction(Restriction restriction, Wikitty w) {
        if (restriction instanceof BinaryOperator) {
            BinaryOperator binOp = (BinaryOperator)restriction;
            if (binOp.getElement().getName().equals(Element.ELT_EXTENSION)) {
                return w.hasExtension(binOp.getValue());
            }
            String fqfieldName = binOp.getElement().getName();
            if (Element.ELT_EXTENSION.equals(fqfieldName)) {
                return true;
            }
            if (Element.ELT_ID.equals(fqfieldName)) {
                return w.getId().equals(binOp.getValue());
            }
            String[] extName = fqfieldName.split("\\.");
            if (!w.hasField(extName[0], extName[1])) {
                return false;
            }
            Object o = w.getFqField(fqfieldName);
            FieldType t = w.getFieldType(fqfieldName);
            Object value = binOp.getValue();
            if (!(value instanceof Collection) && t.isCollection()) {
                value = Collections.singleton(value);
            }
            value = t.getValidValue(value);
            boolean checked = false;
            switch (restriction.getName()) {
                case EQUALS: {
                    checked = value.equals(o);
                    break;
                }
                case LESS: {
                    checked = ((Comparable)o).compareTo(value) < 0;
                    break;
                }
                case LESS_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) <= 0;
                    break;
                }
                case GREATER: {
                    checked = ((Comparable)o).compareTo(value) > 0;
                    break;
                }
                case GREATER_OR_EQUAL: {
                    checked = ((Comparable)o).compareTo(value) >= 0;
                    break;
                }
                case NOT_EQUALS: {
                    checked = !value.equals(o);
                    break;
                }
                case ENDS_WITH: {
                    if (t.getType() != FieldType.TYPE.STRING) {
                        throw new WikittyException("Can't search for contents that 'ends with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).endsWith((String)value);
                    break;
                }
                case STARTS_WITH: {
                    if (t.getType() != FieldType.TYPE.STRING) {
                        throw new WikittyException("Can't search for contents that 'starts with' on attribute type different of String. Attribute " + fqfieldName + " is " + t.getType().name());
                    }
                    checked = ((String)o).startsWith((String)value);
                }
            }
            return checked;
        }
        if (restriction instanceof And) {
            And and = (And)restriction;
            for (Restriction sub : and.getRestrictions()) {
                if (this.checkRestriction(sub, w)) continue;
                return false;
            }
            return true;
        }
        throw new UnsupportedOperationException((Object)((Object)restriction.getName()) + " Search Not yet implemented");
    }

    @Override
    public PagedResult<String> findAllByCriteria(WikittyTransaction transaction, Criteria criteria) {
        int firstIndex = criteria.getFirstIndex();
        int endIndex = criteria.getEndIndex();
        LinkedList<String> ids = new LinkedList<String>();
        int currentIndex = 0;
        for (Map.Entry<String, Wikitty> entry : this.wikittyStorage.getWikitties().entrySet()) {
            Wikitty w = entry.getValue();
            String id = entry.getKey();
            Restriction dto = criteria.getRestriction();
            if (w.isDeleted() || !this.checkRestriction(dto, w)) continue;
            if (++currentIndex > firstIndex) {
                ids.add(id);
            }
            if (endIndex < 0 || currentIndex < endIndex) continue;
            break;
        }
        return new PagedResult<String>(firstIndex, ids.size(), criteria.getRestriction().toString(), null, ids);
    }

    @Override
    public Integer findNodeCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Integer> findAllChildrenCount(WikittyTransaction transaction, Wikitty w, Criteria filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

