/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.FacetTopic;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUtil;

public class PagedResult<T>
implements Serializable {
    private static Log log = LogFactory.getLog(PagedResult.class);
    private static final long serialVersionUID = 8518774558223121855L;
    protected int firstIndice;
    protected int numFound;
    protected String queryString;
    protected List<T> results;
    protected Map<String, List<FacetTopic>> facets;

    public PagedResult(int firstIndice, int numFound, String queryString, Map<String, List<FacetTopic>> facets, List<T> results) {
        this.firstIndice = firstIndice;
        this.numFound = numFound;
        this.queryString = queryString;
        this.facets = facets;
        this.results = Collections.unmodifiableList(results);
    }

    public <E extends BusinessEntityWikitty> PagedResult<E> cast(WikittyProxy proxy, Class<E> clazz) {
        return this.cast(proxy, clazz, true);
    }

    public PagedResult<Wikitty> cast(String securityToken, WikittyService ws) {
        List<Object> castedResult;
        if (this.results.size() == 0) {
            castedResult = new ArrayList();
        } else if (this.results.get(0) instanceof String) {
            List<String> ids = this.results;
            castedResult = ws.restore(securityToken, ids);
        } else {
            throw new ClassCastException("PagedResult don't contains wikitty String id but " + this.results.get(0).getClass());
        }
        PagedResult<Wikitty> result = new PagedResult<Wikitty>(this.firstIndice, this.numFound, this.queryString, this.facets, castedResult);
        return result;
    }

    public PagedResult<Wikitty> cast(String securityToken, WikittyService ws, WikittyTransaction transaction) {
        List<Object> castedResult;
        if (this.results.size() == 0) {
            castedResult = new ArrayList();
        } else if (this.results.get(0) instanceof String) {
            List<String> ids = this.results;
            castedResult = ws.restore(securityToken, transaction, ids);
        } else {
            throw new ClassCastException("PagedResult don't contains wikitty String id but " + this.results.get(0).getClass());
        }
        PagedResult<Wikitty> result = new PagedResult<Wikitty>(this.firstIndice, this.numFound, this.queryString, this.facets, castedResult);
        return result;
    }

    public <E extends BusinessEntityWikitty> PagedResult<E> cast(WikittyProxy proxy, Class<E> clazz, boolean autoconvert) {
        List<BusinessEntityWikitty> castedResult;
        if (this.results.size() > 0 && this.results.get(0) instanceof String) {
            List<String> ids = this.results;
            castedResult = proxy.restore(clazz, ids, !autoconvert);
        } else {
            castedResult = new ArrayList(this.results.size());
            BusinessEntityWikitty sample = (BusinessEntityWikitty)WikittyUtil.newInstance(clazz);
            Collection<WikittyExtension> wantedExtension = sample.getStaticExtensions();
            for (T t : this.results) {
                if (t == null) {
                    castedResult.add(null);
                    continue;
                }
                Wikitty w = null;
                if (t instanceof Wikitty) {
                    w = (Wikitty)t;
                } else if (t instanceof BusinessEntityWikitty) {
                    w = ((BusinessEntityWikitty)t).getWikitty();
                } else {
                    throw new WikittyException(String.format("Illegal object result class '%s' can't convert it to wikitty", t.getClass().getName(), clazz.getName()));
                }
                Collection<WikittyExtension> wikittyExtension = w.getExtensions();
                if (autoconvert || wikittyExtension.containsAll(wantedExtension)) {
                    BusinessEntityWikitty e = (BusinessEntityWikitty)WikittyUtil.newInstance(proxy.getSecurityToken(), proxy.getWikittyService(), clazz, (Wikitty)t);
                    castedResult.add(e);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)I18n._((String)"Illegal object result class '%s' can't convert it to '%s'there is no same extension %s != %s", (Object[])new Object[]{t.getClass().getName(), clazz.getName(), wikittyExtension, wantedExtension}));
            }
        }
        PagedResult result = new PagedResult(this.firstIndice, this.numFound, this.queryString, this.facets, castedResult);
        return result;
    }

    public int getFirstIndice() {
        return this.firstIndice;
    }

    public int getNumFound() {
        return this.numFound;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Collection<String> getFacetNames() {
        Set<String> result = this.facets.keySet();
        return result;
    }

    public List<FacetTopic> getTopic(String facetName) {
        List<FacetTopic> result = this.facets.get(facetName);
        return result;
    }

    public Map<String, List<FacetTopic>> getFacets() {
        return this.facets;
    }

    public T getFirst() {
        T result = this.get(0);
        return result;
    }

    public T get(int i) {
        T result = this.results.get(i);
        return result;
    }

    public List<T> getAll() {
        return this.results;
    }

    public int size() {
        int result = this.results.size();
        return result;
    }
}

