/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicLabelUI;
import org.webharvest.gui.component.Iconifiable;
import org.webharvest.utils.CommonUtil;

public class WHComboBox
extends JComboBox {
    private LCComboBoxUI comboBoxUI = new LCComboBoxUI();
    private boolean setCellFontBasedOnName = false;
    private boolean expectIcons = false;

    public WHComboBox() {
        this.defineLook();
    }

    public WHComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.defineLook();
    }

    public WHComboBox(Object[] items) {
        super(items);
        this.defineLook();
    }

    public WHComboBox(Vector items) {
        super(items);
        this.defineLook();
    }

    private void defineLook() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item;
                if (WHComboBox.this.expectIcons && (item = WHComboBox.this.getSelectedItem()) instanceof Iconifiable) {
                    ((ComboCellRenderer)WHComboBox.this.getRenderer()).setIcon(((Iconifiable)item).getIcon());
                }
            }
        });
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return preferredSize;
    }

    public void addValues(Object[] values) {
        ComboBoxModel model;
        if (values != null && (model = this.getModel()) instanceof DefaultComboBoxModel) {
            DefaultComboBoxModel deafultModel = (DefaultComboBoxModel)model;
            for (int i = 0; i < values.length; ++i) {
                deafultModel.addElement(values[i]);
            }
        }
    }

    public boolean isSetCellFontBasedOnName() {
        return this.setCellFontBasedOnName;
    }

    public void setSetCellFontBasedOnName(boolean setCellFontBasedOnName) {
        this.setCellFontBasedOnName = setCellFontBasedOnName;
    }

    public boolean isExpectIcons() {
        return this.expectIcons;
    }

    public void setExpectIcons(boolean expectIcons) {
        this.expectIcons = expectIcons;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        ((ComboCellRenderer)this.getRenderer()).setEnabled(b);
    }

    private class ComboCellRenderer
    extends DefaultListCellRenderer {
        private ListCellRenderer defaultRenderer;

        private ComboCellRenderer(ListCellRenderer renderer) {
            this.defaultRenderer = renderer;
            this.setOpaque(true);
            this.setUI(new BasicLabelUI(){

                @Override
                public void paint(Graphics g, JComponent c) {
                    int w = ComboCellRenderer.this.getWidth();
                    int h = ComboCellRenderer.this.getHeight();
                    Graphics2D g2 = (Graphics2D)g;
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, h - 1, new Color(215, 211, 204), false);
                    g2.setPaint(gp);
                    g2.fillRect(0, 0, w, h);
                    ComboCellRenderer.this.setForeground(WHComboBox.this.isEnabled() ? Color.black : Color.gray);
                    super.paint(g, c);
                    if (WHComboBox.this.hasFocus()) {
                        g2.setColor(Color.black);
                        g2.setStroke(new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{1.0f}, 1.0f));
                        g2.drawRect(0, 0, w - 1, h - 1);
                    }
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(CommonUtil.nvl(value, ""));
            if (index < 0) {
                return this;
            }
            Component comp = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!isSelected) {
                comp.setBackground(WHComboBox.this.isEditable() ? Color.white : new Color(215, 211, 204));
            }
            if (WHComboBox.this.setCellFontBasedOnName && !CommonUtil.isEmptyString(value)) {
                comp.setFont(new Font(value.toString(), 0, comp.getFont().getSize()));
            }
            if (comp instanceof JLabel && WHComboBox.this.expectIcons) {
                JLabel label = (JLabel)comp;
                if (value instanceof Iconifiable) {
                    Icon icon = ((Iconifiable)value).getIcon();
                    label.setIcon(icon);
                    if (icon != null) {
                        label.setIconTextGap(Math.max(4, 20 - icon.getIconWidth()));
                    }
                } else {
                    label.setIcon(null);
                    label.setIconTextGap(4);
                }
            }
            return comp;
        }
    }

    private class LCComboBoxUI
    extends BasicComboBoxUI {
        private LCComboBoxUI() {
        }

        @Override
        protected JButton createArrowButton() {
            JButton button = new JButton(""){

                @Override
                public void paint(Graphics g) {
                    int w = this.getWidth();
                    int h = this.getHeight();
                    Graphics2D g2 = (Graphics2D)g;
                    GradientPaint gp = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 0.0f, h - 1, new Color(215, 211, 204), false);
                    g2.setPaint(gp);
                    g2.fillRect(0, 0, w, h);
                    g.setColor(WHComboBox.this.isEnabled() ? Color.black : Color.gray);
                    int wh = w / 2;
                    int hh = h / 2;
                    g.drawLine(wh - 3, hh - 2, wh + 3, hh - 2);
                    g.drawLine(wh - 2, hh - 1, wh + 2, hh - 1);
                    g.drawLine(wh - 1, hh, wh + 1, hh);
                    g.drawLine(wh, hh + 1, wh, hh + 1);
                }
            };
            button.setBorder(new EmptyBorder(0, 0, 0, 0));
            return button;
        }

        protected ListCellRenderer createRenderer() {
            return new ComboCellRenderer(super.createRenderer());
        }
    }
}

