/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.tools.osb.mbean.BasicActionBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreEntryBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.ObjStoreTypeBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.LogRecordBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.LogRecordListBean;
import com.arjuna.ats.arjuna.tools.osb.util.ActionWrapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.ObjectInstance;

public class BasicActionBean
extends ObjStoreEntryBean
implements BasicActionBeanMBean {
    protected ActionWrapper action_;
    protected Map<String, LogRecordListBean> lists = new HashMap<String, LogRecordListBean>();
    private boolean activated;

    public BasicActionBean(ObjStoreTypeBean parent, Uid uid) {
        super(parent, uid);
    }

    @Override
    public ObjectInstance register() {
        if (this.activated) {
            this.remove();
        }
        if (this.action_ == null) {
            this.action_ = new BasicActionWrapper(this.uid);
        }
        try {
            this.action_.getAction().activate();
        }
        catch (Exception e) {
            this.addError(e.getMessage());
        }
        this.action_.populateLists(this.lists, this);
        for (LogRecordListBean listBean : this.lists.values()) {
            listBean.register();
        }
        this.activated = true;
        return super.register();
    }

    public void remove() {
        if (this.action_ == null) {
            return;
        }
        this.action_.getAction().deactivate();
        this.activated = false;
        try {
            this.action_.remove();
        }
        catch (ObjectStoreException e) {
            throw new RuntimeException(e);
        }
        this.action_ = null;
        this.unregister();
    }

    @Override
    public int getFailedCount() {
        return this.getListSize("Failed");
    }

    @Override
    public int getHeuristicCount() {
        return this.getListSize("Heuristic");
    }

    @Override
    public int getPendingCount() {
        return this.getListSize("Pending");
    }

    @Override
    public int getPreparedCount() {
        return this.getListSize("Prepared");
    }

    @Override
    public int getReadOnlyCount() {
        return this.getListSize("ReadOnly");
    }

    private int getListSize(String type) {
        LogRecordListBean lb = this.lists.get(type);
        return lb == null ? 0 : lb.getSize();
    }

    public String[] getFailedList() {
        return BasicActionBean.toStringArray(this.lists.get("Failed"));
    }

    public String[] getHeuristicList() {
        return BasicActionBean.toStringArray(this.lists.get("Heuristic"));
    }

    public String[] getPendingList() {
        return BasicActionBean.toStringArray(this.lists.get("Pending"));
    }

    public String[] getPreparedList() {
        return BasicActionBean.toStringArray(this.lists.get("Prepared"));
    }

    public String[] getReadOnlyList() {
        return BasicActionBean.toStringArray(this.lists.get("Readonly"));
    }

    public static String[] toStringArray(LogRecordListBean listBean) {
        Collection<LogRecordBean> beans = listBean.getRegisteredMBeans();
        if (beans != null) {
            String[] res = new String[beans.size()];
            int i = 0;
            for (LogRecordBean bean : beans) {
                res[i++] = bean.getObjectName();
            }
            return res;
        }
        return new String[0];
    }

    public static String[] toStringArray(RecordList rl) {
        String[] res = new String[rl.size()];
        AbstractRecord rec = rl.peekFront();
        int i = 0;
        while (rec != null) {
            res[i++] = rec.getTypeOfObject();
            rec = rl.peekNext(rec);
        }
        return res;
    }

    @Override
    public boolean unregister() {
        Iterator<Map.Entry<String, LogRecordListBean>> i = this.lists.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, LogRecordListBean> entry = i.next();
            if (!entry.getValue().unregister()) continue;
            i.remove();
        }
        return this.lists.size() == 0 && super.unregister();
    }

    public class BasicActionWrapper
    extends BasicAction
    implements ActionWrapper {
        public BasicActionWrapper(Uid objUid) {
            super(objUid);
        }

        @Override
        public BasicAction getAction() {
            return this;
        }

        @Override
        public void populateLists(Map<String, LogRecordListBean> lists, BasicActionBean bean) {
            lists.put("Heuristic", new LogRecordListBean(bean, this.heuristicList, "Heuristic List"));
            lists.put("Failed", new LogRecordListBean(bean, this.failedList, "Failed List"));
            lists.put("Readonly", new LogRecordListBean(bean, this.readonlyList, "Readonly List"));
            lists.put("Pending", new LogRecordListBean(bean, this.pendingList, "Pending List"));
            lists.put("Prepared", new LogRecordListBean(bean, this.preparedList, "Prepared List"));
        }

        @Override
        public void remove() throws ObjectStoreException {
            if (!this.getStore().remove_committed(this.getSavingUid(), this.type())) {
                throw new ObjectStoreException();
            }
        }
    }
}

