/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuiton.wikitty.BusinessEntity;
import org.nuiton.wikitty.BusinessEntityWikitty;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTree;
import org.nuiton.wikitty.WikittyTreeNode;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;

public class WikittyProxy {
    protected WikittyService wikittyService;
    protected String securityToken;

    public WikittyProxy() {
    }

    public WikittyProxy(WikittyService wikittyService) {
        this();
        this.wikittyService = wikittyService;
    }

    public String login(String login, String password) {
        String result = this.wikittyService.login(login, password);
        this.setSecurityToken(result);
        return result;
    }

    public void logout() {
        this.wikittyService.logout(this.securityToken);
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public WikittyService getWikittyService() {
        return this.wikittyService;
    }

    public void setWikittyService(WikittyService wikittyService) {
        this.wikittyService = wikittyService;
    }

    public <E extends BusinessEntity> E cast(BusinessEntity source, Class<E> target) {
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, target, ((BusinessEntityWikitty)source).getWikitty());
        return result;
    }

    public <E extends BusinessEntity> E store(E e) {
        Wikitty w = ((BusinessEntityWikitty)e).getWikitty();
        UpdateResponse resp = this.wikittyService.store(this.securityToken, w);
        resp.update(w);
        return e;
    }

    public <E extends BusinessEntity> List<E> store(List<E> objets) {
        ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(objets.size());
        for (BusinessEntity e : objets) {
            Wikitty w = ((BusinessEntityWikitty)e).getWikitty();
            wikitties.add(w);
        }
        UpdateResponse resp = this.wikittyService.store(this.securityToken, wikitties);
        for (Wikitty w : wikitties) {
            resp.update(w);
        }
        return objets;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id, boolean checkExtension) {
        if (id == null) {
            return null;
        }
        E result = null;
        HashSet<String> extNames = null;
        try {
            Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
            if (wikitty == null) {
                return null;
            }
            if (checkExtension) {
                extNames = new HashSet<String>(wikitty.getExtensionNames());
            }
            result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't restore wikitty", eee);
        }
        if (checkExtension) {
            BusinessEntityWikitty b = (BusinessEntityWikitty)result;
            Collection<WikittyExtension> BusinessEntityStaticExtensions = b.getStaticExtensions();
            for (WikittyExtension ext : BusinessEntityStaticExtensions) {
                String extensionName = ext.getName();
                if (extNames.contains(extensionName)) continue;
                return null;
            }
        }
        return result;
    }

    public Wikitty restore(String id) {
        if (id == null) {
            return null;
        }
        Wikitty wikitty = this.wikittyService.restore(this.securityToken, id);
        return wikitty;
    }

    public <E extends BusinessEntity> E restore(Class<E> clazz, String id) {
        E result = this.restore(clazz, id, false);
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id, boolean checkExtension) {
        List<Wikitty> wikitties = this.wikittyService.restore(this.securityToken, id);
        ArrayList<E> result = new ArrayList<E>();
        for (Wikitty w : wikitties) {
            HashSet<String> extNames = null;
            if (checkExtension) {
                extNames = new HashSet<String>(w.getExtensionNames());
            }
            E dto = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
            if (checkExtension) {
                BusinessEntityWikitty b = (BusinessEntityWikitty)dto;
                for (WikittyExtension ext : b.getStaticExtensions()) {
                    if (extNames.contains(ext.getName())) continue;
                    return null;
                }
            }
            result.add(dto);
        }
        return result;
    }

    public <E extends BusinessEntity> List<E> restore(Class<E> clazz, List<String> id) {
        List<E> result = this.restore(clazz, id, false);
        return result;
    }

    public void delete(String id) {
        this.wikittyService.delete(this.securityToken, id);
    }

    public void delete(Collection<String> ids) {
        this.wikittyService.delete(this.securityToken, ids);
    }

    public <E extends BusinessEntityWikitty> PagedResult<E> findAllByExample(E e, int firstIndex, int endIndex, String ... fieldFacet) {
        Criteria criteria = Search.query(e.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex).setFacetField(fieldFacet);
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<?> result = pagedResult.cast(this, e.getClass(), true);
        return result;
    }

    public <E extends BusinessEntityWikitty> E findByExample(E e) {
        Criteria criteria = Search.query(e.getWikitty()).criteria();
        Wikitty w = this.wikittyService.findByCriteria(this.securityToken, criteria);
        BusinessEntityWikitty result = null;
        if (w != null) {
            result = (BusinessEntityWikitty)WikittyUtil.newInstance(this.securityToken, this.wikittyService, e.getClass(), w);
        }
        return (E)result;
    }

    public <E extends BusinessEntity> PagedResult<E> findAllByCriteria(Class<E> clazz, Criteria criteria) {
        Criteria serviceCriteria;
        Search search;
        BusinessEntityWikitty sample = (BusinessEntityWikitty)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        if (criteria == null) {
            search = Search.query();
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria();
        } else {
            List<String> sortDescending;
            List<String> sortAscending;
            List<Criteria> facetCriteria;
            search = Search.query(criteria);
            search = search.eq(Element.ELT_EXTENSION, extensions);
            serviceCriteria = search.criteria(criteria.getName());
            serviceCriteria.setFirstIndex(criteria.getFirstIndex());
            serviceCriteria.setEndIndex(criteria.getEndIndex());
            List<String> facetField = criteria.getFacetField();
            if (facetField != null) {
                String[] facetFieldTab = new String[facetField.size()];
                serviceCriteria.setFacetField(facetField.toArray(facetFieldTab));
            }
            if ((facetCriteria = criteria.getFacetCriteria()) != null) {
                Criteria[] facetCriteriaTab = new Criteria[facetCriteria.size()];
                serviceCriteria.setFacetCriteria(facetCriteria.toArray(facetCriteriaTab));
            }
            if ((sortAscending = criteria.getSortAscending()) != null) {
                String[] sortAscendingTab = new String[sortAscending.size()];
                serviceCriteria.setSortAscending(sortAscending.toArray(sortAscendingTab));
            }
            if ((sortDescending = criteria.getSortDescending()) != null) {
                String[] sortDescendingTab = new String[sortDescending.size()];
                serviceCriteria.setSortDescending(sortDescending.toArray(sortDescendingTab));
            }
        }
        PagedResult<String> pagedResult = this.wikittyService.findAllByCriteria(this.securityToken, serviceCriteria);
        PagedResult<?> result = pagedResult.cast(this, sample.getClass(), true);
        return result;
    }

    public PagedResult<Wikitty> findAllByCriteria(Criteria criteria) {
        PagedResult<String> resultId = this.wikittyService.findAllByCriteria(this.securityToken, criteria);
        PagedResult<Wikitty> result = resultId.cast(this.securityToken, this.wikittyService);
        return result;
    }

    public <E extends BusinessEntity> E findByCriteria(Class<E> clazz, Criteria criteria) {
        BusinessEntityWikitty sample = (BusinessEntityWikitty)WikittyUtil.newInstance(clazz);
        Wikitty wikitty = sample.getWikitty();
        Collection<String> extensions = wikitty.getExtensionNames();
        Search search = Search.query(criteria);
        search = search.eq(Element.ELT_EXTENSION, extensions);
        criteria = search.criteria(criteria.getName());
        Wikitty w = this.wikittyService.findByCriteria(this.securityToken, criteria);
        E result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, w);
        return result;
    }

    public Wikitty findByCriteria(Criteria criteria) {
        Wikitty wikitty = this.wikittyService.findByCriteria(this.securityToken, criteria);
        return wikitty;
    }

    public WikittyTree restoreTree(String wikittyId) {
        WikittyTree result = this.wikittyService.restoreTree(this.securityToken, wikittyId);
        return result;
    }

    public List<String> deleteTree(String treeNodeId) {
        List<String> result = this.wikittyService.deleteTree(this.securityToken, treeNodeId);
        return result;
    }

    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter) {
        Map.Entry<E, Integer> result = this.restoreNode(clazz, wikittyId, filter, false);
        return result;
    }

    public <E extends BusinessEntity> Map.Entry<E, Integer> restoreNode(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map.Entry<WikittyTreeNode, Integer> node = this.wikittyService.restoreNode(this.securityToken, wikittyId, filter);
        if (node == null) {
            return null;
        }
        E bean = this.restore(clazz, wikittyId, checkExtension);
        if (bean == null) {
            return null;
        }
        AbstractMap.SimpleEntry<E, Integer> result = new AbstractMap.SimpleEntry<E, Integer>(bean, node.getValue());
        return result;
    }

    public <E extends BusinessEntity> Map<E, Integer> restoreChildren(Class<E> clazz, String wikittyId, Criteria filter) {
        Map<E, Integer> result = this.restoreChildren(clazz, wikittyId, filter, false);
        return result;
    }

    public <E extends BusinessEntity> Map<E, Integer> restoreChildren(Class<E> clazz, String wikittyId, Criteria filter, boolean checkExtension) {
        Map<WikittyTreeNode, Integer> result = this.wikittyService.restoreChildren(this.securityToken, wikittyId, filter);
        if (result == null) {
            return null;
        }
        LinkedHashMap<Object, Integer> convertedResult = new LinkedHashMap<Object, Integer>();
        Set<Map.Entry<WikittyTreeNode, Integer>> entries = result.entrySet();
        for (Map.Entry<WikittyTreeNode, Integer> entry : entries) {
            WikittyTreeNode node = entry.getKey();
            String nodeId = node.getWikittyId();
            Object businessEntity = null;
            HashSet<String> extNames = null;
            try {
                Wikitty wikitty = this.wikittyService.restore(this.securityToken, nodeId);
                if (checkExtension) {
                    extNames = new HashSet<String>(wikitty.getExtensionNames());
                }
                businessEntity = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
            }
            catch (SecurityException eee) {
                throw eee;
            }
            catch (Exception eee) {
                throw new WikittyException("Can't restore children", eee);
            }
            boolean goodType = true;
            if (checkExtension) {
                BusinessEntityWikitty businessEntityImpl = (BusinessEntityWikitty)businessEntity;
                Collection<WikittyExtension> staticExtensions = businessEntityImpl.getStaticExtensions();
                Iterator<WikittyExtension> iterator = staticExtensions.iterator();
                while (iterator.hasNext() && goodType) {
                    WikittyExtension ext = iterator.next();
                    if (extNames.contains(ext.getName())) continue;
                    goodType = false;
                }
            }
            if (!goodType) continue;
            Integer nodeCount = entry.getValue();
            convertedResult.put(businessEntity, nodeCount);
        }
        return convertedResult;
    }

    public Wikitty restoreVersion(String wikittyId, String version) {
        Wikitty result = this.wikittyService.restoreVersion(this.securityToken, wikittyId, version);
        return result;
    }

    public <E extends BusinessEntity> boolean hasType(Class<E> clazz, String wikittyId) {
        Object result = null;
        HashSet<String> extNames = null;
        try {
            Wikitty wikitty = this.wikittyService.restore(this.securityToken, wikittyId);
            if (wikitty == null) {
                return false;
            }
            extNames = new HashSet<String>(wikitty.getExtensionNames());
            result = WikittyUtil.newInstance(this.securityToken, this.wikittyService, clazz, wikitty);
        }
        catch (SecurityException eee) {
            throw eee;
        }
        catch (Exception eee) {
            throw new WikittyException("Can't retrieve wikitty needed for hasType test", eee);
        }
        BusinessEntityWikitty b = result;
        for (WikittyExtension ext : b.getStaticExtensions()) {
            if (extNames.contains(ext.getName())) continue;
            return false;
        }
        return true;
    }

    public UpdateResponse storeExtension(WikittyExtension ext) {
        UpdateResponse response = this.wikittyService.storeExtension(this.securityToken, ext);
        return response;
    }

    public UpdateResponse storeExtension(Collection<WikittyExtension> exts) {
        UpdateResponse response = this.wikittyService.storeExtension(this.securityToken, exts);
        return response;
    }

    public WikittyExtension restoreExtension(String extensionId) {
        WikittyExtension extension = this.wikittyService.restoreExtension(this.securityToken, extensionId);
        return extension;
    }

    public WikittyExtension restoreExtensionLastVersion(String extensionName) {
        WikittyExtension extension = this.wikittyService.restoreExtensionLastVersion(this.securityToken, extensionName);
        return extension;
    }

    public List<String> getAllExtensionIds() {
        List<String> result = this.wikittyService.getAllExtensionIds(this.securityToken);
        return result;
    }

    public List<String> getAllExtensionsRequires(String extensionName) {
        List<String> result = this.wikittyService.getAllExtensionsRequires(this.securityToken, extensionName);
        return result;
    }

    public void clear() {
        this.wikittyService.clear(this.securityToken);
    }

    public UpdateResponse syncEngin() {
        UpdateResponse result = this.wikittyService.syncEngin(this.securityToken);
        return result;
    }
}

