/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiTestAbstract;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.dto.VradiCartographyDTO;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import com.jurismarches.vradi.services.managers.PropertiesManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.search.Search;

public class VradiStorageServiceTest
extends VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiStorageServiceTest.class);

    protected int[] initData(WikittyExtension extension) throws Exception {
        PropertiesManager.setLastItemOfXmlStream((String)extension.getId(), null);
        List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
        XmlStream xmlStream = this.createXmlStream(extension, bindings);
        return this.storageService.getFormsFromXmlStream(xmlStream, null);
    }

    @Test
    public void testXmlStreamDuplication() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        PropertiesManager.setLastItemOfXmlStream((String)extension.getId(), null);
        List<XmlFieldBinding> bindings = this.createXmlBindings(extension);
        XmlStream xmlStream = this.createXmlStream(extension, bindings);
        long currentTimeMillis = System.currentTimeMillis();
        this.storageService.getFormsFromXmlStream(xmlStream, null);
        this.testSearch("*", 5);
        this.storageService.getFormsFromXmlStream(xmlStream, null);
        this.testSearch("*", 5);
        log.debug((Object)(System.currentTimeMillis() - currentTimeMillis));
    }

    @Test
    public void testDateInterval() throws Exception {
        WikittyExtension extension = this.createFileFormType();
        int[] initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData[0]);
        VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        Date end = new Date();
        GregorianCalendar begin = new GregorianCalendar();
        begin.setTime(end);
        begin.set(12, begin.get(12) - 1);
        formPageDTO = this.storageService.findForms2(null, null, "Infogene.creationDate", begin.getTime(), end, null, null, formPageDTO);
        int total = formPageDTO.getTotalFoundFormNb();
        Assert.assertEquals((long)4L, (long)total);
        formPageDTO = this.storageService.findForms2(null, null, "Infogene.creationDate", begin.getTime(), begin.getTime(), null, null, formPageDTO);
        total = formPageDTO.getTotalFoundFormNb();
        Assert.assertEquals((long)0L, (long)total);
    }

    @Test
    public void testSearchFile() throws Exception {
        WikittyExtension extension = this.createFileFormType();
        int[] initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData[0]);
        this.testSearch((String)null, 4);
        this.testSearch("", 4);
        this.testSearch("*", 4);
        this.testSearch("soir\u00e9e", 1);
        this.testSearch("soiree", 1);
        this.testSearch("description:soir\u00e9e", 1);
        this.testSearch("description:soiree", 1);
        this.testSearch("dir:(tmp)", 4);
        this.testSearch("dir:(/tmp)", 4);
        this.testSearch("dir:(NOT /tmp)", 0);
        this.testSearch("NOT dir:(/tmp)", 0);
        this.testSearch("name:(tr.txt)", 1);
        this.testSearch("name:(enscript.txt)", 1);
        this.testSearch("name:(wifi.txt)", 1);
        this.testSearch("name:(tr.txt OR enscript.txt)", 2);
        this.testSearch("name:(tr.txt AND enscript.txt)", 0);
        this.testSearch("name:(tr.txt OR enscript.txt OR wifi.txt)", 3);
        this.testSearch("name:(tr.txt OR enscript.txt) OR name:(wifi.txt)", 3);
        this.testSearch("name:(tr.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt AND enscript.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt OR enscript.txt) OR dir:(/tmp)", 4);
        this.testSearch("name:(tr.txt OR enscript.txt) AND dir:(/tmp)", 2);
        this.testSearch("name:[e TO u]", 2);
        this.testSearch("name:[e TO v]", 3);
        this.testSearch("name:[e TO w]", 3);
        this.testSearch("name:[e TO x]", 4);
        this.testSearch("size:(203)", 1);
        this.testSearch("size:203", 1);
        this.testSearch("size:203 OR size:814", 2);
        this.testSearch("size:203 AND size:814", 0);
        this.testSearch("size:(203 OR 814) AND NOT size:125", 2);
        this.testSearch("size:(814)", 1);
        this.testSearch("size:(125)", 1);
        this.testSearch("size:(490)", 1);
        this.testSearch("size:(203 OR 814 OR 125 OR 490)", 4);
        this.testSearch("size:(203 OR 814) AND NOT size:(490)", 2);
        this.testSearch("size:(203) OR name:(tr.txt)", 1);
        this.testSearch("size:(203 OR 814 OR 125 OR 490) AND name:(tr.txt OR enscript.txt)", 2);
        this.testSearch("size:(203 OR 814 OR 125 OR 490) OR name:(tr.txt OR enscript.txt)", 4);
        this.testSearch("size:[125 TO 900]", 4);
        this.testSearch("size:[100 TO 300]", 2);
        this.testSearch("modified:(2009-11-29)", 1);
        this.testSearch("modified:(2008-12-21)", 1);
        this.testSearch("modified:(2009-09-28)", 1);
        this.testSearch("modified:(2009-09-06)", 1);
        this.testSearch("modified:[2008 TO 2009]", 1);
        this.testSearch("modified:[2008 TO 2009-10]", 3);
        this.testSearch("lastModified:06/09/2009", 1);
        this.testSearch("lastModified:\"06/09/2009\"", 1);
        this.testSearch("lastModified:28/09/2009", 1);
        this.testSearch("lastModified:\"28/09/2009\"", 1);
        this.testSearch("lastModified:[20090906 TO 20090928]", 2);
        this.testSearch("lastModified:[20090906 TO 20090920]", 1);
        VradiFormPageDTO testSearch = this.testSearch("size:203");
        Form form = (Form)testSearch.getFormsToShow().get(0);
        this.testSearch("id:" + form.getId(), 1);
        this.testSearch("id:" + form.getWikittyId(), 1);
    }

    @Test
    public void testSearchAnnonce() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        int[] initData = this.initData(extension);
        Assert.assertEquals((long)5L, (long)initData[0]);
        this.testSearch((String)null, 5);
        this.testSearch("", 5);
        this.testSearch("*", 5);
        this.testSearch("Localit\u00e9", 2);
        this.testSearch("Localite", 2);
        this.testSearch("acheteur:(Infocom94)", 1);
        this.testSearch("acheteur:(Infocom)", 1);
        this.testSearch("acheteur:(Ville de Nogent sur Marne)", 1);
        this.testSearch("acheteur:(Ville de Saint Joseph)", 1);
        this.testSearch("acheteur:(\"Ville de Saint Joseph\")", 1);
        this.testSearch("acheteur:(Ville)", 2);
        this.testSearch("acheteur:(Ville de)", 2);
        this.testSearch("acheteur:(Marne)", 1);
        this.testSearch("acheteur:(Joseph)", 1);
        this.testSearch("acheteur:(EMOC)", 2);
        this.testSearch("acheteur:(*OC)", 2);
        this.testSearch("acheteur:EM*", 2);
        this.testSearch("acheteur:(EM*)", 2);
        this.testSearch("acheteur:(E*OC)", 2);
        this.testSearch("acheteur:(E?OC)", 2);
        this.testSearch("acheteur:(EM?C)", 2);
        this.testSearch("acheteur:(EMO?)", 2);
        this.testSearch("acheteur:(EM??C)", 0);
        this.testSearch("departement:(972)", 1);
        this.testSearch("departement:(2)", 0);
        this.testSearch("departement:(*2)", 1);
        this.testSearch("departement:(94)", 2);
        this.testSearch("departement:(9)", 0);
        this.testSearch("departement:9*", 3);
        this.testSearch("departement:(9*)", 3);
        this.testSearch("departement:(N.D.)", 2);
        this.testSearch("date:(N.D.)", 2);
        this.testSearch("date:(\\-\\-\\-)", 1);
        this.testSearch("date:(25/01/2010)", 1);
        this.testSearch("date:(19/01/2010)", 1);
        this.testSearch("date:(25/01/2010*)", 1);
        this.testSearch("date:(19/01/2010*)", 1);
        this.testSearch("date:(\"25/01/2010 17:00\")", 1);
        this.testSearch("date:(\"19/01/2010 - 11:00\")", 1);
    }

    @Test
    public void testDateFormats() throws Exception {
        WikittyExtension extension = this.createDatesFormType();
        int[] initData = this.initData(extension);
        Assert.assertEquals((long)30L, (long)initData[0]);
        Assert.assertEquals((long)5L, (long)initData[2]);
    }

    @Test
    public void testSearchStatus() throws Exception {
        this.testSearch((Status[])null, 0);
        Status testStatus1 = this.createSatus("test1", null, 0, false);
        Status testStatus2 = this.createSatus("test2", null, 0, false);
        FormImpl fWithStatus1 = new FormImpl();
        fWithStatus1.setObjet("form with status1");
        fWithStatus1.setStatus(testStatus1.getWikittyId());
        this.storageService.updateEntity((BusinessEntity)fWithStatus1);
        FormImpl fWithStatus2 = new FormImpl();
        fWithStatus2.setObjet("form with status2");
        fWithStatus2.setStatus(testStatus2.getWikittyId());
        this.storageService.updateEntity((BusinessEntity)fWithStatus2);
        FormImpl fWithoutStatus = new FormImpl();
        fWithoutStatus.setObjet("form without status");
        this.storageService.updateEntity((BusinessEntity)fWithoutStatus);
        this.testSearch((Status[])null, 3);
        this.testSearch(new Status[0], 3);
        this.testSearch(new Status[]{testStatus1}, 1);
        this.testSearch(new Status[]{testStatus2}, 1);
        this.testSearch(new Status[]{testStatus1, testStatus2}, 2);
    }

    @Test
    public void testSearchThesaurus() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        WikittyExtension thesaurusExtension = this.createThesaurusExtension();
        this.initData(extension);
        this.testSearch("", 5);
        TreeNodeImpl abc = this.createThesaurus("ab c", null, thesaurusExtension, "ab c");
        TreeNodeImpl def = this.createThesaurus("de f", abc.getWikittyId(), thesaurusExtension, "de f");
        TreeNodeImpl ghi = this.createThesaurus("gh & i", abc.getWikittyId(), thesaurusExtension, "gh & i");
        TreeNodeImpl jkl = this.createThesaurus("jk l", abc.getWikittyId(), thesaurusExtension, "jk l");
        TreeNodeImpl abc2 = this.createThesaurus("ab c", jkl.getWikittyId(), thesaurusExtension, "ab c");
        TreeNodeImpl def2 = this.createThesaurus("de f", jkl.getWikittyId(), thesaurusExtension, "de f");
        TreeNodeImpl ghi2 = this.createThesaurus("gh & i", jkl.getWikittyId(), thesaurusExtension, "gh & i");
        VradiFormPageDTO result = this.testSearch("acheteur:(\"Ville de Nogent sur Marne\")");
        Form form1 = (Form)result.getFormsToShow().get(0);
        form1.addThesaurus(abc.getWikittyId());
        form1.addThesaurus(ghi.getWikittyId());
        this.storageService.updateForm(form1);
        result = this.testSearch("acheteur:(\"Ville de Saint Joseph\")");
        Form form2 = (Form)result.getFormsToShow().get(0);
        form2.addThesaurus(jkl.getWikittyId());
        form2.addThesaurus(ghi2.getWikittyId());
        this.storageService.updateForm(form2);
        result = this.testSearch("acheteur:Infocom94");
        Form form3 = (Form)result.getFormsToShow().get(0);
        form3.addThesaurus(def.getWikittyId());
        form3.addThesaurus(abc2.getWikittyId());
        this.storageService.updateForm(form3);
        this.testSearch("thesaurus:(\"ab c\")", 2);
        this.testSearch("thesaurus:(\"de f\")", 1);
        this.testSearch("thesaurus:(\"gh \\& i\")", 2);
        this.testSearch("thesaurus:(\"jk l\")", 1);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"gh \\& i\")", 1);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"gh \\& i\")", 3);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"de f\")", 1);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"de f\")", 2);
        this.testSearch("thesaurus:(\"ab c\") AND thesaurus:(\"jk l\")", 0);
        this.testSearch("thesaurus:(\"ab c\") OR thesaurus:(\"jk l\")", 3);
        this.testSearch("thesaurus:(\"de f\") OR thesaurus:(\"gh \\& i\")", 3);
    }

    @Test
    public void testPropositions() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        WikittyExtension thesaurusExtension = this.createThesaurusExtension();
        this.initData(extension);
        List list = this.storageService.proposeThesaurus(null, null);
        Assert.assertNull((Object)list);
        VradiFormPageDTO fpNogent = this.testSearch("Nogent");
        Form fNogent = (Form)fpNogent.getFormsToShow().get(0);
        Assert.assertNotNull((Object)fNogent);
        list = this.storageService.proposeThesaurus(fNogent, null);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)0L);
        TreeNodeImpl nogent = this.createThesaurus("Nogent", thesaurusExtension, "Nogent");
        list = this.storageService.proposeThesaurus(fNogent, null);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)1L);
        Assert.assertNotNull(list.get(0));
        Assert.assertEquals((Object)((TreeNodeImpl)list.get(0)).getWikittyId(), (Object)nogent.getWikittyId());
        fNogent.addThesaurus(nogent.getWikittyId());
        list = this.storageService.proposeThesaurus(fNogent, null);
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @Test
    public void testPropositions2() throws Exception {
        WikittyExtension thesaurusExt = this.createThesaurusExtension();
        WikittyExtension extension = this.createFileFormType();
        this.initData(extension);
        TreeNodeImpl tagSoiree = this.createThesaurus("abc", thesaurusExt, "soir\u00e9e");
        TreeNodeImpl tagFrites = this.createThesaurus("def", thesaurusExt, "frites");
        Form formSoiree = (Form)this.testSearch("description:soir\u00e9e").getFormsToShow().get(0);
        List nodes = this.storageService.proposeThesaurus(formSoiree, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)1L);
        String node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        Assert.assertEquals((Object)node1, (Object)tagSoiree.getWikittyId());
        Form formFrites = (Form)this.testSearch("description:frites").getFormsToShow().get(0);
        nodes = this.storageService.proposeThesaurus(formFrites, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)1L);
        node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        Assert.assertEquals((Object)node1, (Object)tagFrites.getWikittyId());
        TreeNodeImpl tagSoireeFrites = this.createThesaurus("ghi", thesaurusExt, "soir\u00e9e", "frites");
        nodes = this.storageService.proposeThesaurus(formSoiree, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        String node2 = ((TreeNodeImpl)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagSoiree.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagSoiree.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        nodes = this.storageService.proposeThesaurus(formFrites, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        node2 = ((TreeNodeImpl)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagFrites.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagFrites.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        TreeNodeImpl tagSoeur = this.createThesaurus("jkl", thesaurusExt, "soeur");
        nodes = this.storageService.proposeThesaurus(formSoiree, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)2L);
        node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        node2 = ((TreeNodeImpl)nodes.get(1)).getWikittyId();
        Assert.assertTrue((node1.equals(tagSoiree.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagSoiree.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) ? 1 : 0) != 0);
        nodes = this.storageService.proposeThesaurus(formFrites, null);
        Assert.assertNotNull((Object)nodes);
        Assert.assertEquals((long)nodes.size(), (long)3L);
        node1 = ((TreeNodeImpl)nodes.get(0)).getWikittyId();
        node2 = ((TreeNodeImpl)nodes.get(1)).getWikittyId();
        String node3 = ((TreeNodeImpl)nodes.get(2)).getWikittyId();
        Assert.assertTrue((node1.equals(tagFrites.getWikittyId()) || node1.equals(tagSoireeFrites.getWikittyId()) || node1.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node2.equals(tagFrites.getWikittyId()) || node2.equals(tagSoireeFrites.getWikittyId()) || node2.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
        Assert.assertTrue((node3.equals(tagFrites.getWikittyId()) || node3.equals(tagSoireeFrites.getWikittyId()) || node3.equals(tagSoeur.getWikittyId()) ? 1 : 0) != 0);
    }

    @Test
    public void testQueryArchiving() throws Exception {
        this.createClient("Client", "test1", "test2");
        this.createUser("User", "test1", "test2");
        this.createGroup("Group", "test1", "test2");
    }

    @Test
    public void testExportAsCSV() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        Search search = Search.query().keyword("*");
        Criteria criteria = search.criteria();
        String exportString = this.storageService.exportAsCSV(criteria);
        FileUtils.writeStringToFile((File)File.createTempFile("export", ".csv"), (String)exportString);
        Assert.assertNotNull((Object)exportString);
        Assert.assertTrue((exportString.indexOf("annonce.description") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImportAsCSV() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        URL importURL = VradiStorageServiceTest.class.getResource("/csv/testimport.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        Search search = Search.query().keyword("*");
        Criteria criteria = search.criteria();
        String exportString = this.storageService.exportAsCSV(criteria);
        FileUtils.writeStringToFile((File)File.createTempFile("exportimport", ".csv"), (String)exportString);
        Assert.assertNotNull((Object)exportString);
        Assert.assertTrue((exportString.indexOf("TATA TOTO") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testImportAsCSVWithQueries() throws Exception {
        WikittyExtension extension = this.createAnnonceFormType();
        this.initData(extension);
        URL importURL = VradiStorageServiceTest.class.getResource("/csv/testimportqueries.csv");
        this.storageService.importAsCSV(importURL.toExternalForm());
        Search search = Search.query().keyword("*");
        Criteria criteria = search.criteria();
        String exportString = this.storageService.exportAsCSV(criteria);
        FileUtils.writeStringToFile((File)File.createTempFile("exportimport", ".csv"), (String)exportString);
        Assert.assertNotNull((Object)exportString);
        Assert.assertFalse((exportString.indexOf("Infogene.id=") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCartographieThesaurus() throws Exception {
        WikittyExtension extension = this.createFileFormType();
        WikittyExtension thesaurusExtension = this.createThesaurusExtension();
        int[] initData = this.initData(extension);
        Assert.assertEquals((long)4L, (long)initData[0]);
        TreeNodeImpl rootThesaurus = this.storageService.getRootThesaurus();
        TreeNodeImpl abc = this.createThesaurus("abc", rootThesaurus.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl def = this.createThesaurus("def", abc.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl ghi = this.createThesaurus("ghi", abc.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl jkl = this.createThesaurus("jkl", abc.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl mno = this.createThesaurus("mno", jkl.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl pqr = this.createThesaurus("pqr", jkl.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl stu = this.createThesaurus("stu", jkl.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl vwx = this.createThesaurus("vwx", stu.getWikittyId(), thesaurusExtension, new String[0]);
        TreeNodeImpl yza = this.createThesaurus("yza", stu.getWikittyId(), thesaurusExtension, new String[0]);
        VradiFormPageDTO result1 = this.testSearch("size:203");
        Form form1 = (Form)result1.getFormsToShow().get(0);
        form1.addThesaurus(abc.getWikittyId());
        form1.addThesaurus(mno.getWikittyId());
        form1.addThesaurus(yza.getWikittyId());
        this.storageService.updateForm(form1);
        VradiFormPageDTO result2 = this.testSearch("size:125");
        Form form2 = (Form)result2.getFormsToShow().get(0);
        form2.addThesaurus(jkl.getWikittyId());
        form2.addThesaurus(stu.getWikittyId());
        form2.addThesaurus(vwx.getWikittyId());
        this.storageService.updateForm(form2);
        VradiCartographyDTO cartographyDTO = this.storageService.getThesaurusCartography("size:125 OR size:203", null, null, null, null, null, null);
        Map cartography = cartographyDTO.getCartography();
        for (Map.Entry entry : cartography.entrySet()) {
            TreeNodeImpl key = (TreeNodeImpl)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (key.getName().equals("abc")) {
                Assert.assertEquals((Object)new Integer(2), (Object)value);
                continue;
            }
            if (key.getName().equals("def")) {
                Assert.assertEquals((Object)new Integer(0), (Object)value);
                continue;
            }
            if (key.getName().equals("ghi")) {
                Assert.assertEquals((Object)new Integer(0), (Object)value);
                continue;
            }
            if (key.getName().equals("jkl")) {
                Assert.assertEquals((Object)new Integer(2), (Object)value);
                continue;
            }
            if (key.getName().equals("mno")) {
                Assert.assertEquals((Object)new Integer(1), (Object)value);
                continue;
            }
            if (key.getName().equals("pqr")) {
                Assert.assertEquals((Object)new Integer(0), (Object)value);
                continue;
            }
            if (key.getName().equals("stu")) {
                Assert.assertEquals((Object)new Integer(2), (Object)value);
                continue;
            }
            if (key.getName().equals("vwx")) {
                Assert.assertEquals((Object)new Integer(1), (Object)value);
                continue;
            }
            if (!key.getName().equals("yza")) continue;
            Assert.assertEquals((Object)new Integer(1), (Object)value);
        }
    }

    public void testCartographieThesaurus2() throws Exception {
        if (log.isInfoEnabled()) {
            log.info((Object)"Testing cartographie (scalling)...");
        }
        WikittyExtension thesaurusExtension = this.createThesaurusExtension();
        int THESAURUS_NUMBER = 500;
        ArrayList<TreeNodeImpl> treeNodes = new ArrayList<TreeNodeImpl>();
        TreeNodeImpl rootThesaurus = this.storageService.getRootThesaurus();
        for (int indexThesaurus = 0; indexThesaurus < 500; ++indexThesaurus) {
            TreeNodeImpl node = this.createThesaurus("thesaurus " + indexThesaurus, rootThesaurus.getWikittyId(), thesaurusExtension, new String[0]);
            treeNodes.add(node);
        }
        for (int indexForm = 0; indexForm < 1000; ++indexForm) {
            FormImpl monForm = new FormImpl();
            monForm.addTag("bou");
            monForm.setDescription("Mon form " + indexForm);
            for (int i = 0; i < (int)(6.0 * Math.random()); ++i) {
                int randomThesaurus = (int)(500.0 * Math.random());
                monForm.addThesaurus(((TreeNode)treeNodes.get(randomThesaurus)).getWikittyId());
            }
            this.storageService.updateForm((Form)monForm);
        }
        log.info((Object)"Testing cartography...");
        long nanoBefore = System.currentTimeMillis();
        VradiCartographyDTO cartographyDTO = this.storageService.getThesaurusCartography(null, null, null, null, null, null, null);
        long nanoAfter = System.currentTimeMillis();
        log.info((Object)("Cartographie in test 2 took " + (nanoAfter - nanoBefore) + " ms"));
        Map cartography = cartographyDTO.getCartography();
        if (log.isDebugEnabled()) {
            for (Map.Entry entry : cartography.entrySet()) {
                TreeNodeImpl key = (TreeNodeImpl)entry.getKey();
                Integer value = (Integer)entry.getValue();
                log.debug((Object)("[Carto] " + key.getName() + " : " + value));
            }
        }
        Assert.assertEquals((long)500L, (long)cartography.size());
    }
}

