/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.ClientImpl;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupImpl;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.StatusImpl;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserImpl;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlFieldBindingImpl;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.entities.XmlStreamImpl;
import com.jurismarches.vradi.services.ServiceFactory;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.nuiton.util.Resource;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;

public abstract class VradiTestAbstract {
    private static final Log log = LogFactory.getLog(VradiTestAbstract.class);
    protected VradiStorageService storageService = null;

    @Before
    public void clear() throws Exception {
        log.debug((Object)"--clear-----------------------------------------");
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        WikittyService service = proxy.getWikittyService();
        service.clear();
        this.storageService = ServiceFactory.getVradiStorageService();
    }

    protected WikittyExtension createFileFormType() throws Exception {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("name", FieldTypeEnum.STRING.getFieldType());
        fields.put("dir", FieldTypeEnum.STRING.getFieldType());
        fields.put("size", FieldTypeEnum.NUMERIC.getFieldType());
        fields.put("lastModified", FieldTypeEnum.DATE_TIME.getFieldType());
        fields.put("modified", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.TEXT.getFieldType());
        return this.createFormType("file", fields);
    }

    protected WikittyExtension createAnnonceFormType() throws Exception {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("acheteur", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.STRING.getFieldType());
        fields.put("departement", FieldTypeEnum.STRING.getFieldType());
        fields.put("description", FieldTypeEnum.STRING.getFieldType());
        fields.put("intitule", FieldTypeEnum.STRING.getFieldType());
        return this.createFormType("annonce", fields);
    }

    protected WikittyExtension createDatesFormType() throws Exception {
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        fields.put("id", FieldTypeEnum.STRING.getFieldType());
        fields.put("date", FieldTypeEnum.DATE_TIME.getFieldType());
        return this.createFormType("dates", fields);
    }

    protected WikittyExtension createFormType(String name, Map<String, FieldType> fields) throws Exception {
        WikittyExtension extension = this.storageService.getFormType(name);
        if (extension == null) {
            extension = this.storageService.updateFormType2(name, fields, "Form", null);
        }
        return extension;
    }

    protected List<XmlFieldBinding> createXmlBindings(WikittyExtension extension) throws Exception {
        ArrayList<XmlFieldBinding> bindings = new ArrayList();
        String name = extension.getName();
        Collection fieldNames = extension.getFieldNames();
        for (String field : fieldNames) {
            XmlFieldBindingImpl binding = new XmlFieldBindingImpl();
            binding.setFormField(name + "." + field);
            binding.addXmlField(field);
            bindings.add((XmlFieldBinding)binding);
        }
        bindings = this.storageService.updateXmlFieldBindings(bindings);
        return bindings;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings, URL resource) throws Exception {
        XmlStreamImpl stream = new XmlStreamImpl();
        stream.setName(extension.getId());
        stream.setFormTypeName(extension.getName());
        log.info((Object)("Setting xmlStream url to: " + resource.toExternalForm()));
        stream.setUrl(resource.toExternalForm());
        for (XmlFieldBinding fieldBinding : bindings) {
            stream.addXmlFieldBinding(fieldBinding.getWikittyId());
        }
        BusinessEntity updateEntity = this.storageService.updateEntity((BusinessEntity)stream);
        return (XmlStream)updateEntity;
    }

    protected XmlStream createXmlStream(WikittyExtension extension, List<XmlFieldBinding> bindings) throws Exception {
        String url = File.separator + extension.getName() + ".xml";
        URL resource = Resource.getURL((String)url);
        return this.createXmlStream(extension, bindings, resource);
    }

    protected Status createSatus(String name, String description, int value, boolean modifiable) throws Exception {
        StatusImpl status = new StatusImpl();
        status.setName(name);
        status.setDescription(description);
        status.setValue(value);
        status.setModifiable(modifiable);
        BusinessEntity updateEntity = this.storageService.updateEntity((BusinessEntity)status);
        return (Status)updateEntity;
    }

    protected Client createClient(String name, String ... queries) throws Exception {
        ClientImpl client = new ClientImpl();
        for (String query : queries) {
            client.addQueries(query);
        }
        client.setName(name);
        client = (Client)this.storageService.updateEntity((BusinessEntity)client);
        return client;
    }

    protected User createUser(String name, String ... queries) throws Exception {
        UserImpl user = new UserImpl();
        for (String query : queries) {
            user.addQueries(query);
        }
        user.setName(name);
        user = (User)this.storageService.updateEntity((BusinessEntity)user);
        return user;
    }

    protected Group createGroup(String name, String ... queries) throws Exception {
        GroupImpl group = new GroupImpl();
        for (String query : queries) {
            group.addQueries(query);
        }
        group.setName(name);
        group = (Group)this.storageService.updateEntity((BusinessEntity)group);
        return group;
    }

    protected WikittyExtension createThesaurusExtension() throws Exception {
        WikittyExtension thesaurusExtension = Thesaurus.EXTENSION_THESAURUS;
        thesaurusExtension = this.storageService.updateFormType(thesaurusExtension);
        return thesaurusExtension;
    }

    protected TreeNodeImpl createThesaurus(String name, WikittyExtension extension, String ... tags) throws Exception {
        return this.createThesaurus(name, null, extension, tags);
    }

    protected TreeNodeImpl createThesaurus(String name, String parent, WikittyExtension extension, String ... tags) throws Exception {
        TreeNodeImpl result = new TreeNodeImpl();
        result.getWikitty().addExtension(extension);
        result.setName(name);
        result.setParent(parent);
        if (tags != null) {
            result.setField("Thesaurus", "tags", Arrays.asList(tags));
        }
        result = (TreeNodeImpl)this.storageService.updateEntity((BusinessEntity)result);
        return result;
    }

    protected void export(String fileName) throws Exception {
        String exportData = this.storageService.exportData();
        BufferedWriter output = new BufferedWriter(new FileWriter(fileName));
        IOUtils.write((String)exportData, (Writer)output);
        IOUtils.closeQuietly((Writer)output);
    }

    protected void importt(String fileName) throws Exception {
        this.storageService.importData(new File(fileName));
    }

    protected void testSearch(String query, int count) throws Exception {
        VradiFormPageDTO testSearch = this.testSearch(query);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected VradiFormPageDTO testSearch(String query) throws Exception {
        VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        formPageDTO = this.storageService.findForms(query, formPageDTO);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPageDTO);
        }
        return formPageDTO;
    }

    protected void testSearch(Status[] statuses, int count) throws Exception {
        VradiFormPageDTO testSearch = this.testSearch(statuses);
        Assert.assertEquals((long)count, (long)testSearch.getTotalFoundFormNb());
    }

    protected VradiFormPageDTO testSearch(Status[] statuses) throws Exception {
        String[] statusIds = null;
        if (statuses != null) {
            statusIds = new String[statuses.length];
            for (int i = 0; i < statuses.length; ++i) {
                statusIds[i] = statuses[i].getWikittyId();
            }
        }
        VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
        formPageDTO = this.storageService.findForms2(null, null, null, null, null, null, statusIds, formPageDTO);
        if (log.isTraceEnabled()) {
            this.traceFormsFound(formPageDTO);
        }
        return formPageDTO;
    }

    protected void traceFormsFound(VradiFormPageDTO formPageDTO) {
        List forms = formPageDTO.getFormsToShow();
        for (Form form : forms) {
            Collection extensions = form.getExtensionNames();
            log.trace((Object)form.getWikittyId());
            for (String extension : extensions) {
                Collection extensionFields = form.getExtensionFields(extension);
                for (String field : extensionFields) {
                    log.trace((Object)String.format("  %s: %.100s", field, form.getField(extension, field)));
                }
            }
        }
    }
}

