/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingBean;
import com.jurismarches.vradi.services.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.exceptions.TechnicalException;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiSendingDTO extends SendingBean implements VradiDTO<Sending> {

    private static final long serialVersionUID = 1L;

    protected static Log log = LogFactory.getLog(VradiSendingDTO.class);

    VradiClientDTO clientDTO;
    List<VradiFormDTO> formDTOs = new ArrayList<VradiFormDTO>();

    public VradiSendingDTO() {
        setFormDTOs(new ArrayList<Form>());
        Sending$form = new HashSet<String>();
    }

    @Override
    public void fromWikitty(Sending wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setClientDTO(new VradiClientDTO());
            try {
                getClientDTO().fromWikitty(ServiceHelper.getVradiStorageService()
                        .getClient(wikitty.getClient()));
                setClient(getClientDTO().getWikittyId());
            } catch (TechnicalException eee) {
                log.error(eee);
            }
            try {
                clearForm();
                setFormDTOs(ServiceHelper.getVradiStorageService()
                        .getForms(new ArrayList(wikitty.getForm())));
            } catch (TechnicalException eee) {
                eee.printStackTrace();
            }
            setParagraph(wikitty.getParagraph());
            setReceptionProof(wikitty.getReceptionProof());
            setStatus(wikitty.getStatus());
            setReceptionDate(wikitty.getReceptionDate());
            setSentDate(wikitty.getSentDate());
        }
    }

    @Override
    public void toWikitty(Sending wikitty) {
        wikitty.setClient(getClient());
        wikitty.clearForm();
        for (VradiFormDTO formDTO : getFormDTOs()) {
            wikitty.addForm(formDTO.getWikittyId());
        }
        wikitty.setParagraph(getParagraph());
        wikitty.setReceptionProof(getReceptionProof());
        wikitty.setStatus(getStatus());
        wikitty.setReceptionDate(getReceptionDate());
        wikitty.setSentDate(getSentDate());
    }

    @Override
    public void reset() {
        setClientDTO(null);
        setClient(null);
        setFormDTOs(null);
        clearForm();
        setParagraph(null);
        setReceptionProof(false);
        setStatus(null);
        setReceptionDate(null);
        setSentDate(null);
    }

    public VradiClientDTO getClientDTO() {
        return clientDTO;
    }

    public void setClientDTO(VradiClientDTO clientDTO) {
        this.clientDTO = clientDTO;
    }

    public List<VradiFormDTO> getFormDTOs() {
        return formDTOs;
    }

    public void setFormDTOs(List<Form> forms) {
        if (forms != null) {
            this.formDTOs = new ArrayList<VradiFormDTO>();
            for (Form form : forms) {
                VradiFormDTO formDTO = new VradiFormDTO();
                formDTO.fromWikitty(form);
                this.formDTOs.add(formDTO);
            }
        }
    }

}