package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.WikittyExtension;

public interface VradiStorageService {

    // Operation "getEntity"
    BusinessEntity getEntity(String id, Class clazz) throws TechnicalException;

    // Operation "updateEntity"
    BusinessEntity updateEntity(BusinessEntity entity) throws TechnicalException;

    // Operation "deleteEntity"
    void deleteEntity(BusinessEntity entity) throws TechnicalException;

    // Operation "getClient"
    Client getClient(String clientId) throws TechnicalException;

    // Operation "getUser"
    User getUser(String userId) throws TechnicalException;

    // Operation "getGroup"
    Group getGroup(String groupId) throws TechnicalException;

    // Operation "getGroupUsers"
    List<User> getGroupUsers(String groupId) throws TechnicalException;

    // Operation "getClientUsers"
    List<User> getClientUsers(String clientId) throws TechnicalException;

    // Operation "getGroupClients"
    List<Client> getGroupClients(String groupId) throws TechnicalException;

    // Operation "getClientByUserId"
    Client getClientByUserId(String userId) throws TechnicalException;

    // Operation "getGroupsByUserId"
    List<Group> getGroupsByUserId(String userId) throws TechnicalException;

    // Operation "getGroupsByClientId"
    List<Group> getGroupsByClientId(String clientId) throws TechnicalException;

    // Operation "getAllClients"
    List<Client> getAllClients() throws TechnicalException;

    // Operation "getAllGroups"
    List<Group> getAllGroups() throws TechnicalException;

    // Operation "updateXmlFieldBindings"
    List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) throws TechnicalException;

    // Operation "updateFormType"
    WikittyExtension updateFormType(WikittyExtension ext) throws TechnicalException;

    // Operation "updateFormType"
    WikittyExtension updateFormType(String name, Map<java.lang.String, org.sharengo.wikitty.FieldType> fields, String requires) throws TechnicalException;

    // Operation "updateForm"
    Form updateForm(Form form) throws TechnicalException;

    // Operation "getXmlStream"
    XmlStream getXmlStream(String xmlStreamId) throws TechnicalException;

    // Operation "getXmlFieldBindings"
    List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) throws TechnicalException;

    // Operation "getXmlFieldBinding"
    XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) throws TechnicalException;

    // Operation "getThesaurus"
    TreeNode getThesaurus(String ThesaurusId) throws TechnicalException;

    // Operation "getRootThesaurus"
    TreeNode getRootThesaurus() throws TechnicalException;

    // Operation "getFormTypeFields"
    Map<java.lang.String, org.sharengo.wikitty.FieldType> getFormTypeFields(String name) throws TechnicalException;

    // Operation "getFormType"
    WikittyExtension getFormType(String name) throws TechnicalException;

    // Operation "getForm"
    Form getForm(String formId) throws TechnicalException;

    // Operation "getAllXmlStreams"
    List<XmlStream> getAllXmlStreams() throws TechnicalException;

    // Operation "getAllThesaurus"
    List<TreeNode> getAllThesaurus() throws TechnicalException;

    // Operation "getAllFormTypes"
    List<WikittyExtension> getAllFormTypes() throws TechnicalException;

    // Operation "getAllForms"
    List<Form> getAllForms() throws TechnicalException;

    // Operation "findForms"
    List<Form> findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, java.util.List[] theasurus) throws TechnicalException;

    // Operation "findForms"
    List<Form> findForms(String query) throws TechnicalException;

    // Operation "deleteForm"
    void deleteForm(String formId) throws TechnicalException;

    // Operation "bindFormsToClients"
    void bindFormsToClients() throws TechnicalException;

    // Operation "getFormsByClients"
    List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension) throws TechnicalException;

    // Operation "getClientsByForms"
    Map<com.jurismarches.vradi.entities.Form, java.util.List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) throws TechnicalException;

    // Operation "getFormsFromXmlStream"
    String getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded) throws TechnicalException;

    // Operation "changeDataDir"
    void changeDataDir(String newDataDir, String oldDataDir) throws TechnicalException;

    // Operation "getAllUsers"
    List<User> getAllUsers() throws TechnicalException;

    // Operation "getQueriesReturningForm"
    List<String> getQueriesReturningForm(Form form) throws TechnicalException;

    // Operation "getForms"
    List<Form> getForms(List<String> formIds) throws TechnicalException;

} //VradiStorageService
