/*
 * #%L
 * SGQ :: Web
 * $Id: ProductListAction.java 371 2013-05-22 12:13:51Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductListAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.model.ProductSearchModel;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class ProductListAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    private static final Log log = LogFactory.getLog(ProductListAction.class);

    protected ReferentialService referentialService;

    protected ProductSearchModel search;

    protected List<ProductStatus> productStatuses;
    
    protected List<AnalyzeType> analyzeTypes;

    protected List<String> productCategories;

    protected int page;

    protected PagerBean pager;

    protected List<Product> products;

    public ProductSearchModel getSearch() {
        if (search == null) {
            search = new ProductSearchModel();
        }
        return search;
    }

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public void prepare() throws Exception {
        // traite ici les parametres que struts aura du mal a gere ti seul
        referentialService = newService(ReferentialService.class);

        // search.productStatusId
        String[] productStatusIds = getParameters("search.productStatusId");
        List<ProductStatus> productStatus = new ArrayList<ProductStatus>();
        if (productStatusIds != null) {
            for (String productStatusId : productStatusIds) {
                productStatus.add(referentialService.getProductStatusById(productStatusId));
            }
        }
        getSearch().setProductStatus(productStatus);

        // search.analyzeTypeId
        String[] analyzeTypeIds = getParameters("search.analyzeTypeId");
        List<AnalyzeType> analyzeTypes = new ArrayList<AnalyzeType>();
        if (analyzeTypeIds != null) {
            for (String analyzeTypeId : analyzeTypeIds) {
                analyzeTypes.add(referentialService.findAnalyzeTypeById(analyzeTypeId));
            }
        }
        getSearch().setAnalyzeTypes(analyzeTypes);
    }

    @Override
    public String execute() throws Exception {

        productStatuses = referentialService.findAllProductStatus();
        analyzeTypes = referentialService.findAllAnalyzeTypes();
        productCategories = referentialService.findAllProductCategories();
        Pair<List<Product>, Long> result = referentialService.getProducts(getSearch(), ITEM_PER_PAGE * page, ITEM_PER_PAGE);
        products = result.getKey();
        long totalCount = result.getValue();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public List<ProductStatus> getProductStatuses() {
        return productStatuses;
    }

    public List<String> getProductCategories() {
        return productCategories;
    }

    public PagerBean getPager() {
        return pager;
    }

    public List<Product> getProducts() {
        return products;
    }
    
    @Action(value="product-export", results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        InputStream result = null;
        try {
            result = referentialService.getProductsAsCsv(getSearch());
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get csv stream", ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "produits.csv";
    }
}
