/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeEditAction.java 214 2012-12-05 16:12:45Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.Date;
import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class BatchAnalyzeEditAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected BatchService batchService;

    protected ReferentialService referentialService;

    protected String batchId;

    protected List<AnalyzeType> analyzeTypes;

    protected Batch batch;

    protected String analyzeTypeId;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    public void prepare() throws Exception {
        batchService = newService(BatchService.class);
        referentialService = newService(ReferentialService.class);
    }

    @Override
    public String input() throws Exception {
        batch = batchService.getBatchById(batchId);
        analyzeTypes = referentialService.findAllAnalyzeTypes();

        return INPUT;
    }

    public Batch getBatch() {
        return batch;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch-view", "batchId", "${batch.topiaId}"})})
    public String execute() throws Exception {

        batch = batchService.getBatchById(batchId);
        AnalyzeType analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        
        BatchAnalyze analyze = new BatchAnalyzeImpl();
        analyze.setBatch(batch);
        analyze.setAnalyzeType(analyzeType);
        analyze.setCreationDate(new Date());

        batchService.saveAnalyze(analyze);

        return SUCCESS;
    }
}
