package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class LabelErrorAbstract extends TopiaEntityAbstract implements LabelError {

    /**
     * Nom de l'attribut en BD : line
     */
    protected String line;

    /**
     * Nom de l'attribut en BD : message
     */
    protected String message;

    /**
     * Nom de l'attribut en BD : labelDate
     */
    protected Date labelDate;

    /**
     * Nom de l'attribut en BD : modified
     */
    protected boolean modified;

    /**
     * Nom de l'attribut en BD : deleted
     */
    protected boolean deleted;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected String comment;

    /**
     * Nom de l'attribut en BD : source
     */
    protected Zone source;

    /**
     * Nom de l'attribut en BD : afterBatchExpiration
     */
    protected Batch afterBatchExpiration;

    private static final long serialVersionUID = 3545521897136796721L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_LINE, String.class, line);
        visitor.visit(this, PROPERTY_MESSAGE, String.class, message);
        visitor.visit(this, PROPERTY_LABEL_DATE, Date.class, labelDate);
        visitor.visit(this, PROPERTY_MODIFIED, boolean.class, modified);
        visitor.visit(this, PROPERTY_DELETED, boolean.class, deleted);
        visitor.visit(this, PROPERTY_COMMENT, String.class, comment);
        visitor.visit(this, PROPERTY_SOURCE, Zone.class, source);
        visitor.visit(this, PROPERTY_AFTER_BATCH_EXPIRATION, Batch.class, afterBatchExpiration);
        visitor.end(this);
    }

    @Override
    public void setLine(String line) {
        String oldValue = this.line;
        fireOnPreWrite(PROPERTY_LINE, oldValue, line);
        this.line = line;
        fireOnPostWrite(PROPERTY_LINE, oldValue, line);
    }

    @Override
    public String getLine() {
        fireOnPreRead(PROPERTY_LINE, line);
        String result = this.line;
        fireOnPostRead(PROPERTY_LINE, line);
        return result;
    }

    @Override
    public void setMessage(String message) {
        String oldValue = this.message;
        fireOnPreWrite(PROPERTY_MESSAGE, oldValue, message);
        this.message = message;
        fireOnPostWrite(PROPERTY_MESSAGE, oldValue, message);
    }

    @Override
    public String getMessage() {
        fireOnPreRead(PROPERTY_MESSAGE, message);
        String result = this.message;
        fireOnPostRead(PROPERTY_MESSAGE, message);
        return result;
    }

    @Override
    public void setLabelDate(Date labelDate) {
        Date oldValue = this.labelDate;
        fireOnPreWrite(PROPERTY_LABEL_DATE, oldValue, labelDate);
        this.labelDate = labelDate;
        fireOnPostWrite(PROPERTY_LABEL_DATE, oldValue, labelDate);
    }

    @Override
    public Date getLabelDate() {
        fireOnPreRead(PROPERTY_LABEL_DATE, labelDate);
        Date result = this.labelDate;
        fireOnPostRead(PROPERTY_LABEL_DATE, labelDate);
        return result;
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldValue = this.modified;
        fireOnPreWrite(PROPERTY_MODIFIED, oldValue, modified);
        this.modified = modified;
        fireOnPostWrite(PROPERTY_MODIFIED, oldValue, modified);
    }

    @Override
    public boolean isModified() {
        fireOnPreRead(PROPERTY_MODIFIED, modified);
        boolean result = this.modified;
        fireOnPostRead(PROPERTY_MODIFIED, modified);
        return result;
    }

    @Override
    public boolean getModified() {
        fireOnPreRead(PROPERTY_MODIFIED, modified);
        boolean result = this.modified;
        fireOnPostRead(PROPERTY_MODIFIED, modified);
        return result;
    }

    @Override
    public void setDeleted(boolean deleted) {
        boolean oldValue = this.deleted;
        fireOnPreWrite(PROPERTY_DELETED, oldValue, deleted);
        this.deleted = deleted;
        fireOnPostWrite(PROPERTY_DELETED, oldValue, deleted);
    }

    @Override
    public boolean isDeleted() {
        fireOnPreRead(PROPERTY_DELETED, deleted);
        boolean result = this.deleted;
        fireOnPostRead(PROPERTY_DELETED, deleted);
        return result;
    }

    @Override
    public boolean getDeleted() {
        fireOnPreRead(PROPERTY_DELETED, deleted);
        boolean result = this.deleted;
        fireOnPostRead(PROPERTY_DELETED, deleted);
        return result;
    }

    @Override
    public void setComment(String comment) {
        String oldValue = this.comment;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public String getComment() {
        fireOnPreRead(PROPERTY_COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(PROPERTY_COMMENT, comment);
        return result;
    }

    @Override
    public void setSource(Zone source) {
        Zone oldValue = this.source;
        fireOnPreWrite(PROPERTY_SOURCE, oldValue, source);
        this.source = source;
        fireOnPostWrite(PROPERTY_SOURCE, oldValue, source);
    }

    @Override
    public Zone getSource() {
        fireOnPreRead(PROPERTY_SOURCE, source);
        Zone result = this.source;
        fireOnPostRead(PROPERTY_SOURCE, source);
        return result;
    }

    @Override
    public void setAfterBatchExpiration(Batch afterBatchExpiration) {
        Batch oldValue = this.afterBatchExpiration;
        fireOnPreWrite(PROPERTY_AFTER_BATCH_EXPIRATION, oldValue, afterBatchExpiration);
        this.afterBatchExpiration = afterBatchExpiration;
        fireOnPostWrite(PROPERTY_AFTER_BATCH_EXPIRATION, oldValue, afterBatchExpiration);
    }

    @Override
    public Batch getAfterBatchExpiration() {
        fireOnPreRead(PROPERTY_AFTER_BATCH_EXPIRATION, afterBatchExpiration);
        Batch result = this.afterBatchExpiration;
        fireOnPostRead(PROPERTY_AFTER_BATCH_EXPIRATION, afterBatchExpiration);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //LabelErrorAbstract
