package com.herbocailleau.sgq.entities;

import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class AnalyzeTypeAbstract extends TopiaEntityAbstract implements AnalyzeType {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : durationDays
     */
    protected int durationDays;

    /**
     * Nom de l'attribut en BD : analyzeCategory
     */
    protected AnalyzeCategory analyzeCategory;

    private static final long serialVersionUID = 7077235528453011511L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DURATION_DAYS, int.class, durationDays);
        visitor.visit(this, PROPERTY_ANALYZE_CATEGORY, AnalyzeCategory.class, analyzeCategory);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setDurationDays(int durationDays) {
        int oldValue = this.durationDays;
        fireOnPreWrite(PROPERTY_DURATION_DAYS, oldValue, durationDays);
        this.durationDays = durationDays;
        fireOnPostWrite(PROPERTY_DURATION_DAYS, oldValue, durationDays);
    }

    @Override
    public int getDurationDays() {
        fireOnPreRead(PROPERTY_DURATION_DAYS, durationDays);
        int result = this.durationDays;
        fireOnPostRead(PROPERTY_DURATION_DAYS, durationDays);
        return result;
    }

    @Override
    public void setAnalyzeCategory(AnalyzeCategory analyzeCategory) {
        AnalyzeCategory oldValue = this.analyzeCategory;
        fireOnPreWrite(PROPERTY_ANALYZE_CATEGORY, oldValue, analyzeCategory);
        this.analyzeCategory = analyzeCategory;
        fireOnPostWrite(PROPERTY_ANALYZE_CATEGORY, oldValue, analyzeCategory);
    }

    @Override
    public AnalyzeCategory getAnalyzeCategory() {
        fireOnPreRead(PROPERTY_ANALYZE_CATEGORY, analyzeCategory);
        AnalyzeCategory result = this.analyzeCategory;
        fireOnPostRead(PROPERTY_ANALYZE_CATEGORY, analyzeCategory);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //AnalyzeTypeAbstract
