/*
 * #%L
 * SGQ :: Business
 * $Id: InventoryBean.java 287 2013-03-21 15:40:48Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/services/csv/InventoryBean.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.services.csv;

import java.util.Date;

import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.Zone;

/**
 * Bean d'inport export inventaire.
 * 
 * zone, emplacement, code produit, nom produit, lot, valeurs relevées
 * 
 * @author echatellier
 */
public class InventoryBean {

    public static final String PROPERTY_ZONE = "zone";
    public static final String PROPERTY_PLACE = "place";
    public static final String PROPERTY_PRESENTATION_CODE = "presentationCode";
    public static final String PROPERTY_PRODUCT = "product";
    public static final String PROPERTY_BATCH = "batch";
    public static final String PROPERTY_DLUO = "dluo";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_REAL_QUANTITY = "realQuantity";

    protected Zone zone;

    protected Place place;

    protected PresentationCode presentationCode;

    protected Product product;

    protected Batch batch;

    protected Date dluo;

    protected String comment;

    protected Double realQuantity;

    public Zone getZone() {
        return zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public Place getPlace() {
        return place;
    }

    public void setPlace(Place place) {
        this.place = place;
    }

    public PresentationCode getPresentationCode() {
        return presentationCode;
    }

    public void setPresentationCode(PresentationCode presentationCode) {
        this.presentationCode = presentationCode;
    }

    public Product getProduct() {
        return product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Batch getBatch() {
        return batch;
    }

    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    public Date getDluo() {
        return dluo;
    }

    public void setDluo(Date dluo) {
        this.dluo = dluo;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Double getRealQuantity() {
        return realQuantity;
    }

    public void setRealQuantity(Double realQuantity) {
        this.realQuantity = realQuantity;
    }
}
