/*
 * #%L
 * SGQ :: Business
 * $Id: MigrationResolver.java 394 2013-06-19 08:44:58Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.3/sgq-business/src/main/java/com/herbocailleau/sgq/business/migration/MigrationResolver.java $
 * %%
 * Copyright (C) 2012, 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.migration;

import org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersion;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver;
import org.nuiton.util.Version;

/**
 * Association entre les numero de version et les classes de migration.
 * 
 * @author Eric Chatellier
 */
public class MigrationResolver implements MigrationCallBackForVersionResolver {

    @Override
    public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {
        Class<? extends MigrationCallBackForVersion> result = null;

        if (version.equals(DatabaseMigration.VERSION_11)) {
            result = MigrationV0V11.class;
        }
        return result;
    }

}
