/*
 * #%L
 * SGQ :: Business
 * $Id: ProductStatusDAOImpl.java 289 2013-03-25 09:18:28Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-business/src/main/java/com/herbocailleau/sgq/entities/ProductStatusDAOImpl.java $
 * %%
 * Copyright (C) 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.entities;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.nuiton.topia.TopiaException;

public class ProductStatusDAOImpl<E extends ProductStatus> extends ProductStatusDAOAbstract<E> {

    /**
     * Retourne les statuts ordonnés par nom with entity count that use each status.
     * 
     * @return status and count
     * @throws TopiaException 
     */
    public Map<ProductStatus, Long> findAllWithProductCount() throws TopiaException {
        String query = "SELECT PS, " +
                " (select count(*) from " + Product.class.getName() + " P" +
                "  where PS in elements (P." + Product.PROPERTY_PRODUCT_STATUS + "))" +
                " from " + ProductStatus.class.getName() + " PS" +
                " order by " + ProductStatus.PROPERTY_NAME;

        List<Object[]> results = (List<Object[]>)context.findAll(query);
        Map<ProductStatus, Long> statuses = new LinkedHashMap<ProductStatus, Long>();
        for (Object[] result : results) {
            statuses.put((ProductStatus)result[0], ((Number)result[1]).longValue());
        }

        return statuses;
    }
}
