/*
 * #%L
 * SGQ :: Business
 * $Id: SgqUtils.java 333 2013-04-22 15:04:32Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-business/src/main/java/com/herbocailleau/sgq/business/SgqUtils.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business;

import static org.nuiton.i18n.I18n._;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import org.nuiton.util.StringUtil;

import com.herbocailleau.sgq.entities.Product;

public class SgqUtils {

    protected static final DateFormat DF_DDMMYYY = new SimpleDateFormat("dd/MM/yyyy");

    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#0.0##", new DecimalFormatSymbols(Locale.US));

    /**
     * Les unités des produits sont définis par le prefix de leurs code.
     * 
     * <ul>
     * <li>ZY : 1000 unit
     * <li>ZX,ZV : L
     * <li>Le reste : kg
     * </ul>
     * 
     * TODO echatellier à voir comment lié ca à la configuration, c'est pas
     *  super évident.
     *  
     * @return l'unité du produit
     */
    public static String getProductUnit(SgqBusinessConfig config, Product product) {
        String code = product.getCode();
        String result = null;
        if (code.charAt(0) == 'Z') {
            switch (code.charAt(1)) {
            case 'Y':
                result = _("000 Unit\u00E9s");
                break;
            case 'X':
            case 'V':
                result = _("L");
                break;
            default:
                result = _("kg");
            }
        } else {
            result = _("kg");
        }
        return result;
    }

    /**
     * Parse sgq date in dd/MM/yyyy date format.
     * 
     * @param value value to parse
     * @return parsed date
     * @throws ParseException 
     */
    public static Date parseSgqDate(String value) throws ParseException {
        return DF_DDMMYYY.parse(value);
    }
    
    /**
     * Format sgq date in dd/MM/yyyy date format.
     * 
     * @param value value to parse
     * @return parsed date
     */
    public static String formatSgqDate(Date value) {
        return DF_DDMMYYY.format(value);
    }

    /**
     * Get sha1 encoding for string list
     * 
     * @param values
     * @return
     */
    public static String getSHA1Hash(String... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            builder.append(value);
        }
        return StringUtil.encodeSHA1(builder.toString());
    }

    /**
     * Format a number with only 3 decimal digit.
     * 
     * @param number number to format
     * @return formatted number
     */
    public static String formatNumber(double number) {
        return DECIMAL_FORMAT.format(number);
    }
    
    /**
     * Utility method for view to compute day between two dates.
     * 
     * @param date1 date 1
     * @param date2 date 2
     * @return days between those dates
     */
    public static long daysBetween(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        long diffDays = (date2ms - date1ms) / (24 * 60 * 60 * 1000);
        return diffDays;
    }
}
