/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.services;

import au.com.bytecode.opencsv.CSVReader;
import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationCode;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.ProductionDAO;
import com.herbocailleau.sgq.entities.Zone;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class ProductionService
extends SgqService {
    private static final Log log = LogFactory.getLog(ProductionService.class);

    public Date getLastImportDate(Zone zone) {
        Date result = null;
        try {
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            result = expeditionDAO.findMaxDateForZone(zone);
            Date result2 = productionDAO.findMaxDateForZone(zone);
            if (result2 != null && (result == null || result.before(result2))) {
                result = result2;
            }
        }
        catch (TopiaException ex) {
            throw new SgqBusinessException("Can't get configuration", ex);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ImportLog> importLabelsFile(String fileFilename, File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Importing labels file : " + file));
        }
        String productionFileName = this.config.getLabelProductionFilename();
        Zone sourceZone = null;
        Date lastImport = null;
        if (productionFileName.equalsIgnoreCase(fileFilename)) {
            sourceZone = Zone.ZE;
            lastImport = this.getLastImportDate(Zone.ZE);
        } else {
            String expeditionFileName = this.config.getLabelExpeditionFilename();
            if (!expeditionFileName.equalsIgnoreCase(fileFilename)) {
                throw new SgqBusinessException(I18n._((String)"Nom de fichier '%s' invalide ! (Autoris\u00e9 %s ou %s)", (Object[])new Object[]{fileFilename, productionFileName, expeditionFileName}));
            }
            sourceZone = Zone.ZP;
            lastImport = this.getLastImportDate(Zone.ZP);
        }
        if (lastImport == null) {
            lastImport = new Date(0L);
        }
        Date importFrom = DateUtils.addDays((Date)lastImport, (int)1);
        importFrom = DateUtils.truncate((Date)importFrom, (int)5);
        Date today = DateUtils.truncate((Date)new Date(), (int)5);
        Date lastCommitDate = null;
        ArrayList<ImportLog> importLogs = new ArrayList<ImportLog>();
        boolean errorSpotted = false;
        CSVReader reader = null;
        try {
            reader = new CSVReader((Reader)new FileReader(file));
            ArrayList<String[]> datas = new ArrayList<String[]>();
            String[] csvdata = null;
            while ((csvdata = reader.readNext()) != null) {
                if (csvdata.length <= 1) continue;
                String columns = "";
                for (int i = 0; i < csvdata.length; i += 2) {
                    columns = columns + csvdata[i];
                }
                if (!"DBCPLQ".equals(columns)) {
                    throw new SgqBusinessException(I18n._((String)"Nom de colonne invalides; trouv\u00e9 : %s, attendu : %s", (Object[])new Object[]{columns, "DBCPLQ"}));
                }
                datas.add(csvdata);
            }
            reader.close();
            Collections.sort(datas, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return o1[1].compareTo(o2[1]);
                }
            });
            SimpleDateFormat dfIn = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat dfOut = new SimpleDateFormat("dd/MM/yyyy");
            PresentationDAO presentationDAO = this.daoHelper.getPresentationDAO();
            BatchDAO batchDAO = this.daoHelper.getBatchDAO();
            ExpeditionDAO expeditionDAO = this.daoHelper.getExpeditionDAO();
            ProductionDAO productionDAO = this.daoHelper.getProductionDAO();
            int line = 0;
            for (Object[] objectArray : datas) {
                Date previousDate;
                ++line;
                String dateddMMyy = objectArray[1];
                String clientId = objectArray[5];
                String productId = objectArray[7];
                String batchId = objectArray[9];
                String quantityStr = objectArray[11];
                Date lineDate = dfIn.parse(dateddMMyy);
                if (lineDate.before(importFrom)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)I18n._((String)"Skipping date %s, before %s", (Object[])new Object[]{lineDate.toString(), importFrom.toString()}));
                    continue;
                }
                if (lastCommitDate == null) {
                    lastCommitDate = lineDate;
                }
                if (!errorSpotted && !DateUtils.isSameDay((Date)lineDate, (Date)lastCommitDate)) {
                    this.daoHelper.commit();
                    lastCommitDate = lineDate;
                }
                ImportLog importLog = new ImportLog();
                importLog.setLine(line);
                importLog.setCode(dfOut.format(lineDate));
                importLogs.add(importLog);
                if (errorSpotted) {
                    importLog.setError(errorSpotted);
                    importLog.setMessage(I18n._((String)"Ligne ignor\u00e9e pour les erreurs pr\u00e9c\u00e9dentes", (Object[])new Object[0]));
                    continue;
                }
                if (!lineDate.before(today)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n._((String)"Skipping date of current day %s", (Object[])new Object[]{lineDate.toString()}));
                    }
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Ligne ignor\u00e9e (date du jour)", (Object[])new Object[0]));
                    errorSpotted = true;
                    continue;
                }
                Object batch = batchDAO.findByNumber(Integer.parseInt(batchId));
                if (batch == null) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Impossible de trouver le lot %s", (Object[])new Object[]{batchId}));
                    errorSpotted = true;
                    continue;
                }
                char presentationChar = productId.charAt(0);
                productId = productId.substring(1);
                PresentationCode presentationCode = PresentationCode.getPresentationCodeFor(presentationChar);
                double quantity = Double.parseDouble(quantityStr);
                int client = Integer.parseInt(clientId);
                if (!batch.getProduct().getCode().equals(productId)) {
                    importLog.setError(true);
                    importLog.setMessage(I18n._((String)"Le code produit %s ne correspond pas au code produit attendu pour ce lot %s", (Object[])new Object[]{productId, batch.getProduct().getCode()}));
                    errorSpotted = true;
                    continue;
                }
                List presentations = presentationDAO.findAllByBatch((Batch)batch);
                Presentation originPresentation = null;
                Presentation destPresentation = null;
                for (Presentation presentation : presentations) {
                    if (presentation.getPresentationCode() == PresentationCode._) {
                        originPresentation = presentation;
                    }
                    if (presentationCode != presentation.getPresentationCode()) continue;
                    destPresentation = presentation;
                }
                if (SgqUtils.isInternalClient(this.config, client)) {
                    if (originPresentation == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Can't find original presentation for row " + Arrays.toString(objectArray)));
                        }
                    } else {
                        double presQuantity = originPresentation.getQuantity();
                        originPresentation.setQuantity(presQuantity -= quantity);
                        presentationDAO.update(originPresentation);
                    }
                    if (destPresentation == null) {
                        destPresentation = (Presentation)presentationDAO.create(new Object[0]);
                        destPresentation.setBatch((Batch)batch);
                        destPresentation.setPresentationCode(presentationCode);
                        importLog.setMessage(I18n._((String)"Nouvelle presentation %c pour le lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                    } else {
                        importLog.setMessage(I18n._((String)"Mise \u00e0 jour de la presentation %c du lot %s", (Object[])new Object[]{Character.valueOf(presentationCode.getCode()), batchId}));
                    }
                    double presQuantity = destPresentation.getQuantity();
                    destPresentation.setQuantity(presQuantity += quantity);
                    presentationDAO.update(destPresentation);
                    Production production = (Production)productionDAO.create(new Object[0]);
                    production.setDate(lineDate);
                    production.setQuantity(presQuantity);
                    production.setPresentation(destPresentation);
                    production.setSource(sourceZone);
                    if (client == this.config.getClientInternalZc()) {
                        production.setDestination(Zone.ZC);
                    } else {
                        production.setDestination(sourceZone);
                    }
                    productionDAO.update(production);
                    continue;
                }
                if (destPresentation == null) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find expedition presentation for batch " + batch.getNumber() + ". Create it !"));
                    }
                    destPresentation = (Presentation)presentationDAO.create(new Object[0]);
                    destPresentation.setBatch((Batch)batch);
                    destPresentation.setPresentationCode(presentationCode);
                    destPresentation.setQuantity(0.0);
                    presentationDAO.update(destPresentation);
                    importLog.setMessage(I18n._((String)"Nouvelle expedition pour le lot %s au client %s", (Object[])new Object[]{batchId, client}));
                } else {
                    double presQuantity = destPresentation.getQuantity();
                    destPresentation.setQuantity(presQuantity -= quantity);
                    presentationDAO.update(destPresentation);
                    importLog.setMessage(I18n._((String)"Nouvelle expedition pour le lot %s au client %s", (Object[])new Object[]{batchId, client}));
                }
                Expedition expedition = (Expedition)expeditionDAO.create(new Object[0]);
                expedition.setDate(lineDate);
                expedition.setPresentation(destPresentation);
                expedition.setQuantity(quantity);
                expedition.setClient(clientId);
                expedition.setSource(sourceZone);
                expeditionDAO.update(expedition);
                if (sourceZone != Zone.ZP || (previousDate = batch.getDmesd()) != null && !lineDate.before(previousDate)) continue;
                batch.setDmesd(lineDate);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Update dmesd for batch to " + lineDate));
            }
            if (!errorSpotted && lastCommitDate != null) {
                this.daoHelper.commit();
            } else {
                this.daoHelper.rollback();
            }
        }
        catch (IOException ex) {
            try {
                throw new SgqBusinessException("Can't import label file", ex);
                catch (ParseException ex2) {
                    throw new SgqBusinessException("Can't import label file", ex2);
                }
                catch (TopiaException ex3) {
                    throw new SgqBusinessException("Can't import label file", ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader);
        return importLogs;
    }

    protected boolean isErrorLog(List<ImportLog> importLogs) {
        boolean result = false;
        Iterator<ImportLog> it = importLogs.iterator();
        while (!result && it.hasNext()) {
            if (!it.next().isError()) continue;
            result = true;
        }
        return result;
    }
}

