package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class PresentationDAOAbstract<E extends Presentation> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)Presentation.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.Presentation;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Sale> list = getContext()
                                                    .getDAO(Sale.class)
                                                    .findAllByProperties(Sale.PROPERTY_PRESENTATION, entity);
                                            for (Sale item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getPresentation())) {
                                                    item.setPresentation(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_NAME, v);
        return result;
    }

    public E findByQuantity(double v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_QUANTITY, v);
        return result;
    }

    public List<E> findAllByQuantity(double v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_QUANTITY, v);
        return result;
    }

    public E findByUnit(String v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_UNIT, v);
        return result;
    }

    public List<E> findAllByUnit(String v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_UNIT, v);
        return result;
    }

    public E findByPlace(Place v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_PLACE, v);
        return result;
    }

    public List<E> findAllByPlace(Place v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_PLACE, v);
        return result;
    }

    public E findByBatch(Batch v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_BATCH, v);
        return result;
    }

    public List<E> findAllByBatch(Batch v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_BATCH, v);
        return result;
    }

    public E findByPresentationCode(PresentationCode v) throws TopiaException {
        E result = findByProperty(Presentation.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    public List<E> findAllByPresentationCode(PresentationCode v) throws TopiaException {
        List<E> result = findAllByProperty(Presentation.PROPERTY_PRESENTATION_CODE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Sale.class) {
            SaleDAO dao = (SaleDAO)
                getContext().getDAO(Sale.class);
            tmp = dao.findAllByPresentation(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Sale.class, entity);
        if (!list.isEmpty()) {
            result.put(Sale.class, list);
        }

        return result;
    }

} //PresentationDAOAbstract<E extends Presentation>
