/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public abstract class PDButton
extends PDField {
    static final COSName OFF = COSName.getPDFName("Off");
    public static final int FLAG_RADIO = 32768;
    public static final int FLAG_PUSHBUTTON = 65536;
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDButton(PDAcroForm theAcroForm) {
        super(theAcroForm);
        this.getCOSObject().setItem(COSName.FT, (COSBase)COSName.BTN);
    }

    public PDButton(PDAcroForm acroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(acroForm, field, parentNode);
    }

    public boolean isPushButton() {
        return this.getCOSObject().getFlag(COSName.FF, 65536);
    }

    public void setPushButton(boolean pushbutton) {
        this.getCOSObject().setFlag(COSName.FF, 65536, pushbutton);
    }

    public boolean isRadioButton() {
        return this.getCOSObject().getFlag(COSName.FF, 32768);
    }

    public void setRadioButton(boolean radiobutton) {
        this.getCOSObject().setFlag(COSName.FF, 32768, radiobutton);
    }

    @Override
    public String getDefaultValue() throws IOException {
        COSBase attribute = this.getInheritableAttribute(COSName.DV);
        if (attribute == null) {
            return "";
        }
        if (attribute instanceof COSName) {
            return ((COSName)attribute).getName();
        }
        throw new IOException("Expected a COSName entry but got " + attribute.getClass().getName());
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            this.getCOSObject().removeItem(COSName.DV);
        } else {
            this.getCOSObject().setItem(COSName.DV, (COSBase)COSName.getPDFName(defaultValue));
        }
    }

    public List<String> getOptions() {
        COSBase value = this.getInheritableAttribute(COSName.OPT);
        if (value instanceof COSString) {
            ArrayList<String> array = new ArrayList<String>();
            array.add(((COSString)value).getString());
            return array;
        }
        if (value instanceof COSArray) {
            return COSArrayList.convertCOSStringCOSArrayToList((COSArray)value);
        }
        return Collections.emptyList();
    }

    public void setOptions(List<String> values) {
        if (values == null || values.isEmpty()) {
            this.removeInheritableAttribute(COSName.OPT);
        } else {
            this.setInheritableAttribute(COSName.OPT, COSArrayList.convertStringListToCOSStringCOSArray(values));
        }
    }
}

