/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType7;
import org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.apache.pdfbox.pdmodel.graphics.shading.PatchMeshesShadingContext;
import org.apache.pdfbox.pdmodel.graphics.shading.TensorPatch;
import org.apache.pdfbox.util.Matrix;

class Type7ShadingContext
extends PatchMeshesShadingContext {
    Type7ShadingContext(PDShadingType7 shading, ColorModel colorModel, AffineTransform xform, Matrix matrix, Rectangle deviceBounds) throws IOException {
        super(shading, colorModel, xform, matrix, deviceBounds);
        this.patchList = this.getTensorPatchList(xform, matrix);
        this.createPixelTable();
    }

    private List<Patch> getTensorPatchList(AffineTransform xform, Matrix matrix) throws IOException {
        PDShadingType7 tensorShadingType = (PDShadingType7)this.patchMeshesShadingType;
        COSDictionary dict = tensorShadingType.getCOSObject();
        PDRange rangeX = tensorShadingType.getDecodeForParameter(0);
        PDRange rangeY = tensorShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = tensorShadingType.getDecodeForParameter(2 + i);
        }
        return this.getPatchList(xform, matrix, dict, rangeX, rangeY, colRange, 16);
    }

    @Override
    protected Patch generatePatch(Point2D[] points, float[][] color) {
        return new TensorPatch(points, color);
    }
}

