package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class ReplyFormUI extends JPanel implements FaxToMailUI<ReplyFormUIModel, ReplyFormUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_ATTACHMENT_BUTTON_ENABLED = "addAttachmentButton.enabled";
    public static final String BINDING_ADD_ATTACHMENT_FORM_VISIBLE = "addAttachmentForm.visible";
    public static final String BINDING_ATTACHMENTS_LABEL_FOREGROUND = "attachmentsLabel.foreground";
    public static final String BINDING_ATTACHMENTS_LABEL_TEXT = "attachmentsLabel.text";
    public static final String BINDING_BUTTON_PANEL_LAYOUT_SELECTED = "buttonPanelLayout.selected";
    public static final String BINDING_CCI_FIELD_EDITABLE = "cciField.editable";
    public static final String BINDING_CCI_FIELD_TEXT = "cciField.text";
    public static final String BINDING_CC_FIELD_EDITABLE = "ccField.editable";
    public static final String BINDING_CC_FIELD_TEXT = "ccField.text";
    public static final String BINDING_FORWARD_BUTTON_VISIBLE = "forwardButton.visible";
    public static final String BINDING_FROM_COMBO_BOX_SELECTED_ITEM = "fromComboBox.selectedItem";
    public static final String BINDING_FROM_FIELD_TEXT = "fromField.text";
    public static final String BINDING_FROM_PANEL_LAYOUT_SELECTED = "fromPanelLayout.selected";
    public static final String BINDING_MESSAGE_EDITABLE = "message.editable";
    public static final String BINDING_MESSAGE_TEXT = "message.text";
    public static final String BINDING_SUBJECT_FIELD_EDITABLE = "subjectField.editable";
    public static final String BINDING_SUBJECT_FIELD_TEXT = "subjectField.text";
    public static final String BINDING_TO_FIELD_EDITABLE = "toField.editable";
    public static final String BINDING_TO_FIELD_TEXT = "toField.text";
    public static final String BINDING_VALIDATE_BUTTON_ENABLED = "validateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(ReplyFormUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addAttachmentButton;
    protected JComboBox addAttachmentFile;
    protected Table addAttachmentForm;
    protected JLabel addAttachmentLabel;
    protected JScrollPane attachmentsContainer;
    protected JLabel attachmentsLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalAttachmentLength",  editorName = "attachmentsPanel")
    protected JPanel attachmentsPanel;
    protected JPanel buttonPanel;
    protected CardLayout2Ext buttonPanelLayout;
    protected JButton cancelButton;
    protected JTextField ccField;
    protected JLabel ccLabel;
    protected JTextField cciField;
    protected JLabel cciLabel;
    protected JButton chooseFileButton;
    protected JButton closeButton;
    protected JButton forwardButton;
    @ValidatorField( validatorId = "validator",  propertyName = "from",  editorName = "fromComboBox")
    protected JComboBox fromComboBox;
    protected JTextField fromField;
    protected JLabel fromLabel;
    protected JPanel fromPanel;
    protected CardLayout2Ext fromPanelLayout;
    protected final ReplyFormUIHandler handler = new ReplyFormUIHandler();
    protected JEditorPane message;
    protected ReplyFormUIModel model;
    protected ReplyFormUI replyPanel = this;
    protected JSplitPane splitPane;
    @ValidatorField( validatorId = "validator",  propertyName = "subject",  editorName = "subjectField")
    protected JTextField subjectField;
    protected JLabel subjectLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "to",  editorName = "toField")
    protected JTextField toField;
    protected JLabel toLabel;
    protected JButton validateButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<ReplyFormUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ReplyFormUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public ReplyFormUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI() {
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ReplyFormUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ReplyFormUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__chooseFileButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openLocation();
    }

    public void doActionPerformed__on__closeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__forwardButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.forward();
    }

    public void doItemStateChanged__on__fromComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "from");
    }

    public void doKeyReleased__on__ccField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "cc");
    }

    public void doKeyReleased__on__cciField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "cci");
    }

    public void doKeyReleased__on__message(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "message");
    }

    public void doKeyReleased__on__subjectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "subject");
    }

    public void doKeyReleased__on__toField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "to");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddAttachmentButton() {
        return addAttachmentButton;
    }

    public JComboBox getAddAttachmentFile() {
        return addAttachmentFile;
    }

    public Table getAddAttachmentForm() {
        return addAttachmentForm;
    }

    public JLabel getAddAttachmentLabel() {
        return addAttachmentLabel;
    }

    public JScrollPane getAttachmentsContainer() {
        return attachmentsContainer;
    }

    public JLabel getAttachmentsLabel() {
        return attachmentsLabel;
    }

    public JPanel getAttachmentsPanel() {
        return attachmentsPanel;
    }

    public JPanel getButtonPanel() {
        return buttonPanel;
    }

    public CardLayout2Ext getButtonPanelLayout() {
        return buttonPanelLayout;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JTextField getCcField() {
        return ccField;
    }

    public JLabel getCcLabel() {
        return ccLabel;
    }

    public JTextField getCciField() {
        return cciField;
    }

    public JLabel getCciLabel() {
        return cciLabel;
    }

    public JButton getChooseFileButton() {
        return chooseFileButton;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JButton getForwardButton() {
        return forwardButton;
    }

    public JComboBox getFromComboBox() {
        return fromComboBox;
    }

    public JTextField getFromField() {
        return fromField;
    }

    public JLabel getFromLabel() {
        return fromLabel;
    }

    public JPanel getFromPanel() {
        return fromPanel;
    }

    public CardLayout2Ext getFromPanelLayout() {
        return fromPanelLayout;
    }

    public ReplyFormUIHandler getHandler() {
        return handler;
    }

    public JEditorPane getMessage() {
        return message;
    }

    public ReplyFormUIModel getModel() {
        return model;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public JTextField getSubjectField() {
        return subjectField;
    }

    public JLabel getSubjectLabel() {
        return subjectLabel;
    }

    public JTextField getToField() {
        return toField;
    }

    public JLabel getToLabel() {
        return toLabel;
    }

    public JButton getValidateButton() {
        return validateButton;
    }

    public SwingValidator<ReplyFormUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAddAttachmentForm() {
        if (!allComponentsCreated) {
            return;
        }
        addAttachmentForm.add(addAttachmentLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(addAttachmentFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(chooseFileButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addAttachmentForm.add(addAttachmentButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToAttachmentsContainer() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentsContainer.getViewport().add(SwingUtil.boxComponentWithJxLayer(attachmentsPanel));
    }

    protected void addChildrenToButtonPanel() {
        if (!allComponentsCreated) {
            return;
        }
        buttonPanel.add($JPanel1, "true");
        buttonPanel.add($JPanel2, "false");
    }

    protected void addChildrenToFromPanel() {
        if (!allComponentsCreated) {
            return;
        }
        fromPanel.add(fromField, "true");
        fromPanel.add(SwingUtil.boxComponentWithJxLayer(fromComboBox), "false");
    }

    protected void addChildrenToReplyPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.NORTH);
        add(splitPane, BorderLayout.CENTER);
        add(buttonPanel, BorderLayout.SOUTH);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JPanel0, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAddAttachmentButton() {
        $objectMap.put("addAttachmentButton", addAttachmentButton = new JButton());
        
        addAttachmentButton.setName("addAttachmentButton");
        addAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addAttachmentButton"));
    }

    protected void createAddAttachmentFile() {
        $objectMap.put("addAttachmentFile", addAttachmentFile = new JComboBox());
        
        addAttachmentFile.setName("addAttachmentFile");
        addAttachmentFile.setEditable(true);
    }

    protected void createAddAttachmentForm() {
        $objectMap.put("addAttachmentForm", addAttachmentForm = new Table());
        
        addAttachmentForm.setName("addAttachmentForm");
    }

    protected void createAddAttachmentLabel() {
        $objectMap.put("addAttachmentLabel", addAttachmentLabel = new JLabel());
        
        addAttachmentLabel.setName("addAttachmentLabel");
        addAttachmentLabel.setText(t("faxtomail.reply.attachments.add.label"));
    }

    protected void createAttachmentsContainer() {
        $objectMap.put("attachmentsContainer", attachmentsContainer = new JScrollPane());
        
        attachmentsContainer.setName("attachmentsContainer");
    }

    protected void createAttachmentsLabel() {
        $objectMap.put("attachmentsLabel", attachmentsLabel = new JLabel());
        
        attachmentsLabel.setName("attachmentsLabel");
    }

    protected void createAttachmentsPanel() {
        $objectMap.put("attachmentsPanel", attachmentsPanel = new JPanel());
        
        attachmentsPanel.setName("attachmentsPanel");
        attachmentsPanel.setLayout(new FlowLayout(FlowLayout.LEADING));
    }

    protected void createButtonPanel() {
        $objectMap.put("buttonPanel", buttonPanel = new JPanel());
        
        buttonPanel.setName("buttonPanel");
        buttonPanel.setLayout( buttonPanelLayout );
    }

    protected void createButtonPanelLayout() {
        $objectMap.put("buttonPanelLayout", buttonPanelLayout = new CardLayout2Ext(this, "buttonPanel"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(t("faxtomail.reply.action.cancel"));
        cancelButton.setToolTipText(t("faxtomail.reply.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createCcField() {
        $objectMap.put("ccField", ccField = new JTextField());
        
        ccField.setName("ccField");
        ccField.setColumns(15);
        ccField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__ccField"));
    }

    protected void createCcLabel() {
        $objectMap.put("ccLabel", ccLabel = new JLabel());
        
        ccLabel.setName("ccLabel");
        ccLabel.setText(t("faxtomail.reply.label.cc"));
    }

    protected void createCciField() {
        $objectMap.put("cciField", cciField = new JTextField());
        
        cciField.setName("cciField");
        cciField.setColumns(15);
        cciField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__cciField"));
    }

    protected void createCciLabel() {
        $objectMap.put("cciLabel", cciLabel = new JLabel());
        
        cciLabel.setName("cciLabel");
        cciLabel.setText(t("faxtomail.reply.label.cci"));
    }

    protected void createChooseFileButton() {
        $objectMap.put("chooseFileButton", chooseFileButton = new JButton());
        
        chooseFileButton.setName("chooseFileButton");
        chooseFileButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__chooseFileButton"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(t("faxtomail.reply.action.close"));
        closeButton.setToolTipText(t("faxtomail.reply.action.close.tip"));
        closeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__closeButton"));
    }

    protected void createForwardButton() {
        $objectMap.put("forwardButton", forwardButton = new JButton());
        
        forwardButton.setName("forwardButton");
        forwardButton.setText(t("faxtomail.reply.action.forward"));
        forwardButton.setToolTipText(t("faxtomail.reply.action.forward.tip"));
        forwardButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__forwardButton"));
    }

    protected void createFromComboBox() {
        $objectMap.put("fromComboBox", fromComboBox = new JComboBox());
        
        fromComboBox.setName("fromComboBox");
        fromComboBox.setEditable(true);
        fromComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__fromComboBox"));
    }

    protected void createFromField() {
        $objectMap.put("fromField", fromField = new JTextField());
        
        fromField.setName("fromField");
        fromField.setColumns(15);
        fromField.setEditable(false);
    }

    protected void createFromLabel() {
        $objectMap.put("fromLabel", fromLabel = new JLabel());
        
        fromLabel.setName("fromLabel");
        fromLabel.setText(t("faxtomail.reply.label.from"));
    }

    protected void createFromPanel() {
        $objectMap.put("fromPanel", fromPanel = new JPanel());
        
        fromPanel.setName("fromPanel");
        fromPanel.setLayout( fromPanelLayout );
    }

    protected void createFromPanelLayout() {
        $objectMap.put("fromPanelLayout", fromPanelLayout = new CardLayout2Ext(this, "fromPanel"));
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JEditorPane());
        
        message.setName("message");
        message.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__message"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ReplyFormUIModel.class));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setDividerLocation(270);
    }

    protected void createSubjectField() {
        $objectMap.put("subjectField", subjectField = new JTextField());
        
        subjectField.setName("subjectField");
        subjectField.setColumns(15);
        subjectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__subjectField"));
    }

    protected void createSubjectLabel() {
        $objectMap.put("subjectLabel", subjectLabel = new JLabel());
        
        subjectLabel.setName("subjectLabel");
        subjectLabel.setText(t("faxtomail.reply.label.subject"));
    }

    protected void createToField() {
        $objectMap.put("toField", toField = new JTextField());
        
        toField.setName("toField");
        toField.setColumns(15);
        toField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__toField"));
    }

    protected void createToLabel() {
        $objectMap.put("toLabel", toLabel = new JLabel());
        
        toLabel.setName("toLabel");
        toLabel.setText(t("faxtomail.reply.label.to"));
    }

    protected void createValidateButton() {
        $objectMap.put("validateButton", validateButton = new JButton());
        
        validateButton.setName("validateButton");
        validateButton.setText(t("faxtomail.reply.action.validate"));
        validateButton.setToolTipText(t("faxtomail.reply.action.validate.tip"));
        validateButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.ReplyAction.class );
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(ReplyFormUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToReplyPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(fromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(fromPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(toLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(toField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ccLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ccField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cciLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cciField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(subjectLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(subjectField), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToFromPanel();
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(message);
        // inline complete setup of $JPanel0
        $JPanel0.add(attachmentsLabel, BorderLayout.NORTH);
        $JPanel0.add(attachmentsContainer, BorderLayout.CENTER);
        $JPanel0.add(addAttachmentForm, BorderLayout.SOUTH);
        addChildrenToAttachmentsContainer();
        addChildrenToAddAttachmentForm();
        addChildrenToButtonPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add(forwardButton);
        $JPanel1.add(closeButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(cancelButton);
        $JPanel2.add(validateButton);
        
        // apply 20 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 15 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        attachmentsPanel.setBackground( Color.WHITE );
        chooseFileButton.setIcon(SwingUtil.createActionIcon("open"));
        addAttachmentButton.setIcon(SwingUtil.createActionIcon("add"));
        forwardButton.setIcon(SwingUtil.createActionIcon("transmit"));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        validateButton.setIcon(SwingUtil.createActionIcon("reply"));
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("replyPanel", replyPanel);
        createModel();
        createValidator();
        createFromPanelLayout();
        createButtonPanelLayout();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createFromLabel();
        createFromPanel();
        createFromField();
        createFromComboBox();
        createToLabel();
        createToField();
        createCcLabel();
        createCcField();
        createCciLabel();
        createCciField();
        createSubjectLabel();
        createSubjectField();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMessage();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createAttachmentsLabel();
        createAttachmentsContainer();
        createAttachmentsPanel();
        createAddAttachmentForm();
        createAddAttachmentLabel();
        createAddAttachmentFile();
        createChooseFileButton();
        createAddAttachmentButton();
        createButtonPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createForwardButton();
        createCloseButton();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createValidateButton();
        // inline creation of replyPanel
        setName("replyPanel");
        setLayout(new BorderLayout());
        
        // registers 20 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 20 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_PANEL_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fromPanelLayout.setSelected( String.valueOf(model.isReadonly()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUTTON_PANEL_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    buttonPanelLayout.setSelected( String.valueOf(model.isReadonly()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("from", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(fromField,  model.getFrom() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("from", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FROM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("from", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fromComboBox.setSelectedItem( model.getFrom() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("from", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("to", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(toField,  model.getTo() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("to", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CC_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cc", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ccField,  model.getCc() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cc", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CC_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ccField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CCI_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cci", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(cciField,  model.getCci() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cci", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CCI_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cciField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(subjectField,  model.getSubject() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUBJECT_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subjectField.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("message", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(message,  model.getMessage() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("message", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MESSAGE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    message.setEditable( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("maxAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    attachmentsLabel.setText(t( t("faxtomail.reply.attachments.title",
                                getModel().getTotalAttachmentLength(),
                                getModel().getMaxAttachmentLength()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("maxAttachmentLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_LABEL_FOREGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    attachmentsLabel.setForeground( getModel().isAttachmentSizeValid(getModel().getTotalAttachmentLength()) ? Color.BLACK : Color.RED );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ATTACHMENT_FORM_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("readonly", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addAttachmentForm.setVisible( !model.isReadonly() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("readonly", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_ATTACHMENT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (addAttachmentFile != null) {
                    $bindingSources.put("addAttachmentFile", addAttachmentFile);
                    addAttachmentFile.addItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (addAttachmentFile != null) {
                    addAttachmentButton.setEnabled( addAttachmentFile.getSelectedItem() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (addAttachmentFile != null) {
                    JComboBox $target = (JComboBox) $bindingSources.remove("addAttachmentFile");
                    if ($target != null) {
                        $target.removeItemListener( JAXXUtil.getEventListener(ItemListener.class, this, "$pr$u0"));
                    }
                }
            }
        
            public void $pr$u0(ItemEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORWARD_BUTTON_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    forwardButton.setVisible( getModel().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("valid", this);
                }
                if (getModel() != null) {
                    getModel().addPropertyChangeListener("totalAttachmentLength", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getModel() != null) {
                    validateButton.setEnabled( getModel().isValid() && getModel().isAttachmentSizeValid(getModel().getTotalAttachmentLength()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("valid", this);
                }
                if (getModel() != null) {
                    getModel().removePropertyChangeListener("totalAttachmentLength", this);
                }
            }
        });
    }

}