package com.franciaflex.faxtomail.ui.swing.util;

/*
 * #%L
 * FaxToMail :: UI
 * %%
 * Copyright (C) 2014 Franciaflex
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailImpl;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.nuiton.i18n.I18n.n;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since x.x
 */
public class DemandeTableModel extends AbstractApplicationTableModel<DemandeUIModel> {

    private static final Log log = LogFactory.getLog(DemandeTableModel.class);

    public static final Map<MailField, ColumnIdentifier<Email>> COLUMN_IDENTIFIERS = new HashMap<MailField, ColumnIdentifier<Email>>() {{
        put(MailField.SENDER,
            ColumnIdentifier.<Email>newReadOnlyId(
                Email.PROPERTY_SENDER,
                n("faxtomail.demandeList.table.header.sender"),
                n("faxtomail.demandeList.table.header.sender.tip")));

        put(MailField.OBJECT,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_OBJECT,
                    n("faxtomail.demandeList.table.header.object"),
                    n("faxtomail.demandeList.table.header.object.tip")));

        put(MailField.RECEPTION_DATE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_RECEPTION_DATE,
                    n("faxtomail.demandeList.table.header.receptionDate"),
                    n("faxtomail.demandeList.table.header.receptionDate.tip")));

        put(MailField.RECIPIENT,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_RECIPIENT,
                    n("faxtomail.demandeList.table.header.recipient"),
                    n("faxtomail.demandeList.table.header.recipient.tip")));

        put(MailField.CLIENT_CODE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_CLIENT_CODE,
                    n("faxtomail.demandeList.table.header.client"),
                    n("faxtomail.demandeList.table.header.client.tip")));

        put(MailField.CLIENT_BRAND,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_CLIENT_BRAND,
                    n("faxtomail.demandeList.table.header.brand"),
                    n("faxtomail.demandeList.table.header.brand.tip")));

        put(MailField.DEMAND_STATUS,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_DEMAND_STATUS,
                    n("faxtomail.demandeList.table.header.status"),
                    n("faxtomail.demandeList.table.header.status.tip")));

        put(MailField.DEMAND_TYPE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_DEMAND_TYPE,
                    n("faxtomail.demandeList.table.header.type"),
                    n("faxtomail.demandeList.table.header.type.tip")));

        put(MailField.EDI_RETURN,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_EDI_CODE_NUMBER,
                    n("faxtomail.demandeList.table.header.ediCodeNumber"),
                    n("faxtomail.demandeList.table.header.ediCodeNumber.tip")));

        put(MailField.ETAT_ATTENTE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_ETAT_ATTENTE,
                    n("faxtomail.demandeList.table.header.waitingState"),
                    n("faxtomail.demandeList.table.header.waitingState.tip")));

        put(MailField.TAKEN_BY,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_TAKEN_BY,
                    n("faxtomail.demandeList.table.header.user"),
                    n("faxtomail.demandeList.table.header.user.tip")));

        put(MailField.PRIORITY,
            ColumnIdentifier.<Email>newId(
                    Email.PROPERTY_PRIORITY,
                    n("faxtomail.demandeList.table.header.priority"),
                    n("faxtomail.demandeList.table.header.priority.tip")));

        put(MailField.PROJECT_REFERENCE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_PROJECT_REFERENCE,
                    n("faxtomail.demandeList.table.header.projectReference"),
                    n("faxtomail.demandeList.table.header.projectReference.tip")));

        put(MailField.COMPANY_REFERENCE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    Email.PROPERTY_COMPANY_REFERENCE,
                    n("faxtomail.demandeList.table.header.companyReference"),
                    n("faxtomail.demandeList.table.header.companyReference.tip")));

        put(MailField.REFERENCE,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_REFERENCE,
                    n("faxtomail.demandeList.table.header.reference"),
                    n("faxtomail.demandeList.table.header.reference.tip")));

        put(MailField.PF_NB,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_PF_NB,
                    n("faxtomail.demandeList.table.header.pfNb"),
                    n("faxtomail.demandeList.table.header.pfNb.tip")));

        put(MailField.SAV_NB,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_SAV_NB,
                    n("faxtomail.demandeList.table.header.savNb"),
                    n("faxtomail.demandeList.table.header.savNb.tip")));

        put(MailField.QUOTATION_NB,
            ColumnIdentifier.<Email>newReadOnlyId(
                    DemandeUIModel.PROPERTY_QUOTATION_NB,
                    n("faxtomail.demandeList.table.header.quotationNb"),
                    n("faxtomail.demandeList.table.header.quotationNb.tip")));

        put(MailField.REPLIES,
            ColumnIdentifier.<Email>newId(
                    Email.PROPERTY_REPLIES,
                    n("faxtomail.demandeList.table.header.replies"),
                    n("faxtomail.demandeList.table.header.replies.tip")));

        put(MailField.ATTACHMENT,
            ColumnIdentifier.<Email>newId(
                    Email.PROPERTY_ATTACHMENT,
                    n("faxtomail.demandeList.table.header.attachment"),
                    n("faxtomail.demandeList.table.header.attachment.tip")));

        put(MailField.LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
            ColumnIdentifier.<Email>newId(
                    DemandeUIModel.PROPERTY_LAST_ATTACHMENT_OPENING_IN_THIS_FOLDER_USER,
                    n("faxtomail.demandeList.table.header.lastAttachmentOpeningUser"),
                    n("faxtomail.demandeList.table.header.lastAttachmentOpeningUser.tip")));

        put(MailField.COMMENT,
            ColumnIdentifier.<Email>newId(
                    Email.PROPERTY_COMMENT,
                    n("faxtomail.demandeList.table.header.commen"),
                    n("faxtomail.demandeList.table.header.commen.tip")));

    }};

    public DemandeTableModel(TableColumnModelExt columnModel, MailField... editableProperties) {
        super(columnModel, false, false);
        List<ColumnIdentifier> nonEditableColumns = new ArrayList<ColumnIdentifier>(COLUMN_IDENTIFIERS.values());
        for (MailField editableProperty : editableProperties) {
            nonEditableColumns.remove(COLUMN_IDENTIFIERS.get(editableProperty));
        }
        setNoneEditableCols(nonEditableColumns.toArray(new ColumnIdentifier[nonEditableColumns.size()]));
    }

    @Override
    public DemandeUIModel createNewRow() {
        return new DemandeUIModel();
    }

    @Override
    protected void onRowsChanged(List<DemandeUIModel> data) {
        super.onRowsChanged(data);
    }
}
