package com.franciaflex.faxtomail.ui.swing.util;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: AbstractToolbarPopupButton.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/util/AbstractToolbarPopupButton.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import jaxx.runtime.SwingUtil;
import org.jdesktop.beans.AbstractSerializableBean;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.List;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.*;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public abstract class AbstractToolbarPopupButton<UI extends AbstractToolbarPopupUI> extends JToggleButton {

    private static final long serialVersionUID = 1L;

    protected final UI popup;

    protected boolean popupMoving;

    public AbstractToolbarPopupButton() {

        ImageIcon actionIcon = SwingUtil.createActionIcon(getActionIcon());
        setIcon(actionIcon);
        setDisabledIcon(actionIcon);

        popup = createNewPopup();

        popup.addWindowListener(new WindowAdapter() {

            @Override
            public void windowOpened(WindowEvent e) {
                setSelected(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                setSelected(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                setSelected(false);
            }
        });

        addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                if (isSelected()) {
                    if (!popup.isVisible()) {
                        popup.openEditor(AbstractToolbarPopupButton.this);
                    }
                } else {
                    popup.closeEditor();
                }
            }
        });

        addHierarchyBoundsListener(new HierarchyBoundsAdapter() {

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (popup.isShowing()) {

                    // place dialog just under the button
                    Point point = new Point(getLocationOnScreen());
                    point.translate(-popup.getWidth() + getWidth(), getHeight());
                    popupMoving = true;
                    try {
                        popup.setLocation(point);
                    } finally {
                        popupMoving = false;
                    }
                }
            }
        });
    }

    protected abstract String getActionIcon();

    protected abstract UI createNewPopup();

    public void onCloseUI() {
        setSelected(false);
    }
}