package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class AttachmentEditorUI extends AbstractToolbarPopupUI<AttachmentEditorUIModel, AttachmentEditorUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_BUTTON_ENABLED = "addButton.enabled";
    public static final String BINDING_ATTACHMENTS_VISIBLE = "attachments.visible";
    public static final String BINDING_FORM_PANEL_VISIBLE = "formPanel.visible";
    public static final String BINDING_NO_ATTACHMENTS_LABEL_VISIBLE = "noAttachmentsLabel.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz28bVRCeOHZiJy2URA2p2kqbNkiOFJ4jfkhIqUqbtlYTOYBwkCJ84dn77Lzwdt+yO242WCD+BP4EuHNB4sYJceDMgQviX0CIA1fEvOf1rp1sEh+wrNXqzXwz38yb+fa7P6EUhbB2zOOYhX0fpSfY3uPDw/fbx6KDT0XUCWWAOoThb6YAhRYsuul5hHC/1TDwWgKvPdFeoH3hj6G3G7AQ4akS0ZEQiHB3EtGJolozNW/HQT8cRU1J5UX95u+/Cl+7X31bAIgDYnedSnGuQmWVFBtQkC7CEmV6wWuK+z2iEUq/R3yvm7MnikfRe9wTn8GXMN+AuYCHFAzh3vQl2xgWHwcINzgi7xx5xldypXsIzzvaY92Q+x3Ju0rErMtj1B6XivUli06ID+toHwnCMjR7nL4+cyUl/Gg3CGyeOYSyoCPeVgLhFVMHM7WxHa2V4H7mVvK0KxTC/v/FYN/Ey+IX29o9RVjTYY8d08x8ijoYhovZ3uGBRCXcD7g/DlnN4u8QuNkJtVLGB+FVU0mc0NnLLAa5lAaoEG3fBqWLnUDYQ+N1M3Ve8nVWRNTg7fMoe2jcV1PUYsaRxv/2BdWZ9k/iKl0degm11YkxHebKgVxb32sKGjpO7d1CWJlswchinNfG0kglUtp3J41FY0RYz0kv7CWyOjkM7/NMWO66O31EmgNYnuAxPE28Q7g9EZt2m2W7nS3fTAtKYZ+OqRet83LwIZmGQrB6RghMQGv9d2X5tx//+KE+2v4y5b6Z6zomXrSVQagDEaI0qV8ern4fpart82C7BZVIKFI+q2x3cog1EzORo3zD7TJw9pxHRxSiNP/7Tz+vfPLrLBTqsKA0d+vc+O9CBY9C6oJWbhy8+8gyunZSpucNw43GypO+9PpeU35Ojbo3cHxx4tj4/ATZUyLgR1L71Tfe3tp0tjacL2Lqzp2c7qQU25Vf/llufv9o1KEZYnzrQvesS6WPYU76SvrCKmQifrmKuBhEou/qTOTyZA9ydC9Idv4t+3wnryElNAqB4GRyxM9IDrMucd/EeGArNG8PIdGeq5IUyQ9FTIK+eUmOsXVnwguQJG3+hYyk1df7A8eqKOsJzLSkusFk9Mz4VumiEBa6tDav28Yg9Ra5kh16aevQpVGE7YEzvlE79ng4N6esEwqOwgYbGqpvbjrJ307B+eJzdO2qVhTGi1ofOGtTVDX2mSli2M+9h3GxnOLOMw4ro8ZSyiRN9YJyM2GdosqyMu2oa2p7eeAYOTSlJGPw2iVj0JVCucwA8jmMVPcqDrNUpfBNPe6FVdLE0O3Ttu+a7y7MkvZSK5E+4AcyOLBUNy6bWItlhKIFCXLppmo+xaXMKX6qyRleeuBy5E5b+i7N6cNzgWfM8xZF/A83zk7wWAoAAA==";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JScrollPane attachmentBodyScrollPane;
    protected AttachmentEditorUI attachmentDialog = this;
    protected JXTable attachments;
    protected Boolean editable;
    protected FileEditor file;
    protected JLabel fileLabel;
    protected Table formPanel;
    protected final AttachmentEditorUIHandler handler = new AttachmentEditorUIHandler();
    protected JPanel mainPanel;
    protected AttachmentEditorUIModel model;
    protected JLabel noAttachmentsLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public JXTable getAttachments() {
        return attachments;
    }

    public Boolean getEditable() {
        return editable;
    }

    public FileEditor getFile() {
        return file;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public Table getFormPanel() {
        return formPanel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public AttachmentEditorUIModel getModel() {
        return model;
    }

    public JLabel getNoAttachmentsLabel() {
        return noAttachmentsLabel;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(attachmentBodyScrollPane);
    }

    protected void addChildrenToFormPanel() {
        if (!allComponentsCreated) {
            return;
        }
        formPanel.add($JSeparator0, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(fileLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(file, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        formPanel.add(addButton, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(noAttachmentsLabel, BorderLayout.NORTH);
        mainPanel.add(attachments, BorderLayout.CENTER);
        mainPanel.add(formPanel, BorderLayout.SOUTH);
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("faxtomail.attachmentEditor.action.add.tip"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new JXTable());
        
        attachments.setName("attachments");
        attachments.setEditable(true);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.attachmentEditor.title"));
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createFile() {
        $objectMap.put("file", file = new FileEditor());
        
        file.setName("file");
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(t("faxtomail.attachmentEditor.field.file"));
    }

    protected void createFormPanel() {
        $objectMap.put("formPanel", formPanel = new Table());
        
        formPanel.setName("formPanel");
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = new AttachmentEditorUIModel());
    }

    protected void createNoAttachmentsLabel() {
        $objectMap.put("noAttachmentsLabel", noAttachmentsLabel = new JLabel());
        
        noAttachmentsLabel.setName("noAttachmentsLabel");
        noAttachmentsLabel.setText(t("faxtomail.attachmentEditor.attachments.empty"));
        if (noAttachmentsLabel.getFont() != null) {
            noAttachmentsLabel.setFont(noAttachmentsLabel.getFont().deriveFont(noAttachmentsLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToAttachmentBodyScrollPane();
        addChildrenToMainPanel();
        addChildrenToFormPanel();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setMinimumSize( new java.awt.Dimension(250, 0) );
        noAttachmentsLabel.setBorder( javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        fileLabel.setLabelFor( file );
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        // late initializer
        attachmentDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentDialog", attachmentDialog);
        createEditable();
        createModel();
        createAttachmentBodyScrollPane();
        createMainPanel();
        createNoAttachmentsLabel();
        createAttachments();
        createFormPanel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createFileLabel();
        createFile();
        createAddButton();
        // inline creation of attachmentDialog
        setName("attachmentDialog");
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NO_ATTACHMENTS_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    noAttachmentsLabel.setVisible( model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("attachment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getAttachment() != null) {
                    attachments.setVisible( !model.getAttachment().isEmpty() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("attachment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FORM_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    formPanel.setVisible( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ADD_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    addButton.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
    }

}