/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.CompletedFileDownload;
import software.amazon.awssdk.transfer.s3.FileDownload;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.ToString;

@SdkInternalApi
public final class DefaultFileDownload
implements FileDownload {
    private final CompletableFuture<CompletedFileDownload> completionFuture;
    private final TransferProgress progress;

    DefaultFileDownload(CompletableFuture<CompletedFileDownload> completionFuture, TransferProgress progress) {
        this.completionFuture = completionFuture;
        this.progress = progress;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    @Override
    public CompletableFuture<CompletedFileDownload> completionFuture() {
        return this.completionFuture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultFileDownload that = (DefaultFileDownload)o;
        if (!Objects.equals(this.completionFuture, that.completionFuture)) {
            return false;
        }
        return Objects.equals(this.progress, that.progress);
    }

    public int hashCode() {
        int result = this.completionFuture != null ? this.completionFuture.hashCode() : 0;
        result = 31 * result + (this.progress != null ? this.progress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultFileDownload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).build();
    }
}

