/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.ext;

import de.flapdoodle.embed.process.io.IStreamProcessor;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogWatchStreamProcessor
extends de.flapdoodle.embed.process.io.LogWatchStreamProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogWatchStreamProcessor.class);
    private final StringBuilder output = new StringBuilder();
    private final Object mutex = new Object();
    private final String success;
    private final Set<String> failures;
    private volatile boolean found = false;
    private volatile boolean initWithSuccess = false;

    public LogWatchStreamProcessor(String success, Set<String> failures, IStreamProcessor destination) {
        super(success, failures, destination);
        this.success = Optional.ofNullable(success).orElse("");
        this.failures = failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String block) {
        LOGGER.debug(block);
        this.output.append(block).append("\n");
        this.initWithSuccess = this.containsSuccess(block);
        if (this.initWithSuccess || this.containsFailure(block)) {
            Object object = this.mutex;
            synchronized (object) {
                this.found = true;
                this.mutex.notifyAll();
            }
        } else {
            super.process(block);
        }
    }

    private boolean containsSuccess(String block) {
        return block.contains(this.success);
    }

    private boolean containsFailure(String block) {
        for (String failure : this.failures) {
            if (!block.contains(failure)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResult(long timeout) {
        Object object = this.mutex;
        synchronized (object) {
            try {
                if (!this.found) {
                    this.mutex.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to wait for the result: '{}' not found in: \n{}", (Object)this.success, (Object)this.output);
                e.printStackTrace();
            }
        }
    }

    public boolean isInitWithSuccess() {
        return this.initWithSuccess || this.getOutput().contains(this.success);
    }

    public String getOutput() {
        return this.output.toString();
    }
}

