/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.util;

import java.lang.reflect.Field;
import java.util.Optional;

public final class ReflectUtil {
    private ReflectUtil() {
    }

    public static void setFinalField(Object object, String fieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        assert (object != null);
        assert (fieldName != null);
        Field field = ReflectUtil.getFieldFromClassHierarchy(object.getClass(), fieldName).orElseThrow(NoSuchFieldError::new);
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(object, newValue);
    }

    public static Optional<Field> getFieldFromClassHierarchy(Class<?> clazz, String fieldName) {
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return Optional.of(field);
            }
            clazz = clazz.getSuperclass();
        }
        return Optional.empty();
    }
}

