/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin.manager.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertyWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.extensions.model.factory.SmartWroModelFactory;
import ro.isdc.wro.manager.factory.standalone.ConfigurableStandaloneContextAwareManagerFactory;
import ro.isdc.wro.manager.factory.standalone.StandaloneContext;
import ro.isdc.wro.manager.factory.standalone.StandaloneContextAware;
import ro.isdc.wro.maven.plugin.support.ExtraConfigFileAware;
import ro.isdc.wro.model.factory.ConfigurableModelFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.ConfigurableLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.hash.ConfigurableHashStrategy;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.ConfigurableNamingStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;

public class ConfigurableWroManagerFactory
extends ConfigurableStandaloneContextAwareManagerFactory
implements ExtraConfigFileAware {
    private File configProperties;

    public void initialize(StandaloneContext standaloneContext) {
        Context.get().setConfig(this.initConfiguration());
        super.initialize(standaloneContext);
    }

    private WroConfiguration initConfiguration() {
        return new PropertyWroConfigurationFactory(this.createProperties()).create();
    }

    protected WroModelFactory newModelFactory() {
        return new ConfigurableModelFactory(){

            protected Properties newProperties() {
                return ConfigurableWroManagerFactory.this.createProperties();
            }

            protected WroModelFactory getDefaultStrategy() {
                return SmartWroModelFactory.createFromStandaloneContext((StandaloneContext)ConfigurableWroManagerFactory.this.getStandaloneContext());
            }
        };
    }

    protected NamingStrategy newNamingStrategy() {
        return new ConfigurableNamingStrategy(){

            protected Properties newProperties() {
                return ConfigurableWroManagerFactory.this.createProperties();
            }
        };
    }

    protected HashStrategy newHashStrategy() {
        return new ConfigurableHashStrategy(){

            protected Properties newProperties() {
                return ConfigurableWroManagerFactory.this.createProperties();
            }
        };
    }

    protected UriLocatorFactory newUriLocatorFactory() {
        return new ConfigurableLocatorFactory(){

            public UriLocator getInstance(String uri) {
                UriLocator locator = super.getInstance(uri);
                if (locator != null && locator instanceof StandaloneContextAware) {
                    ((StandaloneContextAware)locator).initialize(ConfigurableWroManagerFactory.this.getStandaloneContext());
                }
                return locator;
            }

            protected Properties newProperties() {
                return ConfigurableWroManagerFactory.this.createProperties();
            }
        };
    }

    protected Properties createProperties() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.configProperties));
            return properties;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while loading properties file from " + this.configProperties.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void setExtraConfigFile(File extraProperties) {
        this.configProperties = extraProperties;
    }
}

