/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import pl.project13.core.log.LoggerBridge;
import pl.project13.maven.git.ReplacementProperty;
import pl.project13.maven.git.TransformationRule;

public class PropertiesReplacer {
    private final LoggerBridge log;
    private final PluginParameterExpressionEvaluator expressionEvaluator;

    public PropertiesReplacer(LoggerBridge log, PluginParameterExpressionEvaluator expressionEvaluator) {
        this.log = log;
        this.expressionEvaluator = expressionEvaluator;
    }

    public void performReplacement(Properties properties, List<ReplacementProperty> replacementProperties) {
        if (replacementProperties != null && properties != null) {
            for (ReplacementProperty replacementProperty : replacementProperties) {
                String propertyKey = replacementProperty.getProperty();
                if (propertyKey == null) {
                    this.performReplacementOnAllGeneratedProperties(properties, replacementProperty);
                    continue;
                }
                this.performReplacementOnSingleProperty(properties, replacementProperty, propertyKey);
            }
        }
    }

    private void performReplacementOnAllGeneratedProperties(Properties properties, ReplacementProperty replacementProperty) {
        for (String propertyName : properties.stringPropertyNames()) {
            String content = properties.getProperty(propertyName);
            String result = this.performReplacement(replacementProperty, content);
            if (replacementProperty.getPropertyOutputSuffix() != null && !replacementProperty.getPropertyOutputSuffix().isEmpty()) {
                String newPropertyKey = propertyName + "." + replacementProperty.getPropertyOutputSuffix();
                properties.setProperty(newPropertyKey, result);
                this.log.info("apply replace on property " + propertyName + " and save to " + newPropertyKey + ": original value '" + content + "' with '" + result + "'");
                continue;
            }
            properties.setProperty(propertyName, result);
            this.log.info("apply replace on property " + propertyName + ": original value '" + content + "' with '" + result + "'");
        }
    }

    private void performReplacementOnSingleProperty(Properties properties, ReplacementProperty replacementProperty, String propertyKey) {
        String content = properties.getProperty(propertyKey);
        String result = this.performReplacement(replacementProperty, content);
        if (replacementProperty.getPropertyOutputSuffix() != null && !replacementProperty.getPropertyOutputSuffix().isEmpty()) {
            String newPropertyKey = propertyKey + "." + replacementProperty.getPropertyOutputSuffix();
            properties.setProperty(newPropertyKey, result);
            this.log.info("apply replace on property " + propertyKey + " and save to " + newPropertyKey + ": original value '" + content + "' with '" + result + "'");
        } else {
            properties.setProperty(propertyKey, result);
            this.log.info("apply replace on property " + propertyKey + ": original value '" + content + "' with '" + result + "'");
        }
    }

    private String performReplacement(ReplacementProperty replacementProperty, String content) {
        String evaluationContent = content;
        if (evaluationContent == null || evaluationContent.isEmpty() || replacementProperty.isForceValueEvaluation()) {
            evaluationContent = replacementProperty.getValue();
        }
        String result = "";
        try {
            result = Optional.ofNullable(this.expressionEvaluator.evaluate(evaluationContent)).map(x -> x.toString()).orElse(evaluationContent);
        }
        catch (Exception e) {
            this.log.error("Something went wrong performing the replacement.", (Throwable)e);
        }
        if (replacementProperty != null) {
            result = this.performTransformationRules(replacementProperty, result, TransformationRule.ApplyEnum.BEFORE);
            result = replacementProperty.isRegex() ? this.replaceRegex(result, replacementProperty.getToken(), replacementProperty.getValue()) : this.replaceNonRegex(result, replacementProperty.getToken(), replacementProperty.getValue());
            result = this.performTransformationRules(replacementProperty, result, TransformationRule.ApplyEnum.AFTER);
        }
        return result;
    }

    private String performTransformationRules(ReplacementProperty replacementProperty, String content, TransformationRule.ApplyEnum forRule) {
        String result = content;
        if (replacementProperty.getTransformationRules() != null && !replacementProperty.getTransformationRules().isEmpty()) {
            for (TransformationRule transformationRule : replacementProperty.getTransformationRules()) {
                if (!transformationRule.getApplyRule().equals((Object)forRule)) continue;
                result = transformationRule.getActionRule().perform(result);
            }
        }
        return result;
    }

    private String replaceRegex(String content, String token, String value) {
        if (token == null) {
            this.log.error("found replacementProperty without required token.");
            return content;
        }
        Pattern compiledPattern = Pattern.compile(token);
        return compiledPattern.matcher(content).replaceAll(value == null ? "" : value);
    }

    private String replaceNonRegex(String content, String token, String value) {
        if (token == null) {
            this.log.error("found replacementProperty without required token.");
            return content;
        }
        return content.replace(token, value == null ? "" : value);
    }
}

