/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.jetbrains.annotations.NotNull;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.util.PropertyManager;

public abstract class GitDataProvider {
    @NotNull
    protected LoggerBridge loggerBridge;
    protected boolean verbose;
    protected String prefixDot;
    protected int abbrevLength;
    protected String dateFormat;
    protected GitDescribeConfig gitDescribe = new GitDescribeConfig();

    public GitDataProvider(@NotNull LoggerBridge loggerBridge) {
        this.loggerBridge = loggerBridge;
    }

    public GitDataProvider setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
        return this;
    }

    public GitDataProvider setPrefixDot(String prefixDot) {
        this.prefixDot = prefixDot;
        return this;
    }

    public GitDataProvider setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
        return this;
    }

    public GitDataProvider setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return this;
    }

    protected abstract void init() throws MojoExecutionException;

    protected abstract String getBuildAuthorName();

    protected abstract String getBuildAuthorEmail();

    protected abstract void prepareGitToExtractMoreDetailedReproInformation() throws MojoExecutionException;

    protected abstract String getBranchName() throws IOException;

    protected abstract String getGitDescribe() throws MojoExecutionException;

    protected abstract String getCommitId();

    protected abstract String getAbbrevCommitId() throws MojoExecutionException;

    protected abstract boolean isDirty() throws MojoExecutionException;

    protected abstract String getCommitAuthorName();

    protected abstract String getCommitAuthorEmail();

    protected abstract String getCommitMessageFull();

    protected abstract String getCommitMessageShort();

    protected abstract String getCommitTime();

    protected abstract String getRemoteOriginUrl() throws MojoExecutionException;

    protected abstract String getTags() throws MojoExecutionException;

    protected abstract String getClosestTagName() throws MojoExecutionException;

    protected abstract String getClosestTagCommitCount() throws MojoExecutionException;

    protected abstract void finalCleanUp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadGitData(@NotNull Properties properties) throws IOException, MojoExecutionException {
        this.init();
        this.put(properties, "build.user.name", this.getBuildAuthorName());
        this.put(properties, "build.user.email", this.getBuildAuthorEmail());
        try {
            this.prepareGitToExtractMoreDetailedReproInformation();
            this.validateAbbrevLength(this.abbrevLength);
            this.put(properties, "branch", this.determineBranchName(System.getenv()));
            this.maybePutGitDescribe(properties);
            this.put(properties, "commit.id", this.getCommitId());
            this.put(properties, "commit.id.abbrev", this.getAbbrevCommitId());
            this.put(properties, "dirty", Boolean.toString(this.isDirty()));
            this.put(properties, "commit.user.name", this.getCommitAuthorName());
            this.put(properties, "commit.user.email", this.getCommitAuthorEmail());
            this.put(properties, "commit.message.full", this.getCommitMessageFull());
            this.put(properties, "commit.message.short", this.getCommitMessageShort());
            this.put(properties, "commit.time", this.getCommitTime());
            this.put(properties, "remote.origin.url", this.getRemoteOriginUrl());
            this.put(properties, "tags", this.getTags());
            this.put(properties, "closest.tag.name", this.getClosestTagName());
            this.put(properties, "closest.tag.commit.count", this.getClosestTagCommitCount());
        }
        finally {
            this.finalCleanUp();
        }
    }

    private void maybePutGitDescribe(@NotNull Properties properties) throws MojoExecutionException {
        boolean isGitDescribeOptOutByConfiguration;
        boolean isGitDescribeOptOutByDefault = this.gitDescribe == null;
        boolean bl = isGitDescribeOptOutByConfiguration = this.gitDescribe != null && !this.gitDescribe.isSkip();
        if (isGitDescribeOptOutByDefault || isGitDescribeOptOutByConfiguration) {
            this.put(properties, "commit.id.describe", this.getGitDescribe());
        }
    }

    void validateAbbrevLength(int abbrevLength) throws MojoExecutionException {
        if (abbrevLength < 2 || abbrevLength > 40) {
            throw new MojoExecutionException("Abbreviated commit id lenght must be between 2 and 40, inclusive! Was [%s]. ".codePointBefore(abbrevLength) + "Please fix your configuration (the <abbrevLength/> element).");
        }
    }

    protected String determineBranchName(Map<String, String> env) throws IOException {
        if (this.runningOnBuildServer(env)) {
            return this.determineBranchNameOnBuildServer(env);
        }
        return this.getBranchName();
    }

    private boolean runningOnBuildServer(Map<String, String> env) {
        return env.containsKey("HUDSON_URL") || env.containsKey("JENKINS_URL");
    }

    protected String determineBranchNameOnBuildServer(Map<String, String> env) throws IOException {
        String enviromentBasedBranch = env.get("GIT_BRANCH");
        if (Strings.isNullOrEmpty((String)enviromentBasedBranch)) {
            this.log("Detected that running on CI enviroment, but using repository branch, no GIT_BRANCH detected.");
            return this.getBranchName();
        }
        this.log("Using environment variable based branch name.", "GIT_BRANCH =", enviromentBasedBranch);
        return enviromentBasedBranch;
    }

    void log(String ... parts) {
        this.loggerBridge.log(parts);
    }

    protected void put(@NotNull Properties properties, String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log(keyWithPrefix, value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }
}

