/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.apache.commons.el;

import org.zkforge.apache.commons.el.BinaryOperator;
import org.zkforge.apache.commons.el.Coercions;
import org.zkforge.apache.commons.el.Constants;
import org.zkforge.apache.commons.el.Logger;
import org.zkforge.apache.commons.el.PrimitiveObjects;
import org.zkoss.xel.XelException;

public class IntegerDivideOperator
extends BinaryOperator {
    public static final IntegerDivideOperator SINGLETON = new IntegerDivideOperator();

    public String getOperatorSymbol() {
        return "idiv";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws XelException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
        try {
            return PrimitiveObjects.getLong(left / right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

