/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.apache.commons.el;

import java.io.StringReader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.zkforge.apache.commons.el.Coercions;
import org.zkforge.apache.commons.el.Constants;
import org.zkforge.apache.commons.el.ELExpression;
import org.zkforge.apache.commons.el.Expression;
import org.zkforge.apache.commons.el.ExpressionApi;
import org.zkforge.apache.commons.el.ExpressionString;
import org.zkforge.apache.commons.el.Logger;
import org.zkforge.apache.commons.el.parser.ELParser;
import org.zkforge.apache.commons.el.parser.ParseException;
import org.zkforge.apache.commons.el.parser.Token;
import org.zkforge.apache.commons.el.parser.TokenMgrError;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;

public class ExpressionEvaluatorImpl {
    static Map sCachedExpressionStrings = Collections.synchronizedMap(new HashMap());
    static Map sCachedExpectedTypes = new HashMap();
    static Logger sLogger = new Logger(System.out);
    boolean mBypassCache;

    public ExpressionEvaluatorImpl() {
    }

    public ExpressionEvaluatorImpl(boolean pBypassCache) {
        this.mBypassCache = pBypassCache;
    }

    public Object evaluate(String pExpressionString, Class pExpectedType, VariableResolver pResolver, FunctionMapper functions) throws XelException {
        return this.evaluate(pExpressionString, pExpectedType, pResolver, functions, sLogger);
    }

    public ExpressionApi parseExpression(String expression, Class expectedType, FunctionMapper fMapper) throws XelException {
        Object parsedValue = this.parseExpressionString(expression);
        return new OldJSTLExpression(expression, parsedValue, expectedType, fMapper);
    }

    public ELExpression parseExpression(String expression, Class expectedType) throws XelException {
        Object parsedValue = this.parseExpressionString(expression);
        return new JSTLExpression(expression, parsedValue, expectedType);
    }

    Object evaluate(String pExpressionString, Class pExpectedType, VariableResolver pResolver, FunctionMapper functions, Logger pLogger) throws XelException {
        if (pExpressionString == null) {
            throw new XelException(Constants.NULL_EXPRESSION_STRING);
        }
        Object parsedValue = this.parseExpressionString(pExpressionString);
        if (parsedValue instanceof String) {
            String strValue = (String)parsedValue;
            return this.convertStaticValueToExpectedType(strValue, pExpectedType, pLogger);
        }
        if (parsedValue instanceof Expression) {
            Object value = ((Expression)parsedValue).evaluate(pResolver, functions, pLogger);
            return this.convertToExpectedType(value, pExpectedType, pLogger);
        }
        if (parsedValue instanceof ExpressionString) {
            String strValue = ((ExpressionString)parsedValue).evaluate(pResolver, functions, pLogger);
            return this.convertToExpectedType(strValue, pExpectedType, pLogger);
        }
        return null;
    }

    public Object parseExpressionString(String pExpressionString) throws XelException {
        Object ret;
        if (pExpressionString.length() == 0) {
            return "";
        }
        Object object = ret = this.mBypassCache ? null : (Object)sCachedExpressionStrings.get(pExpressionString);
        if (ret == null) {
            StringReader r = new StringReader(pExpressionString);
            ELParser parser = new ELParser(r);
            try {
                ret = parser.ExpressionString();
                sCachedExpressionStrings.put(pExpressionString, ret);
            }
            catch (ParseException exc) {
                throw new XelException(ExpressionEvaluatorImpl.formatParseException(pExpressionString, exc));
            }
            catch (TokenMgrError exc) {
                throw new XelException(exc.getMessage());
            }
        }
        return ret;
    }

    Object convertToExpectedType(Object pValue, Class pExpectedType, Logger pLogger) throws XelException {
        return Coercions.coerce(pValue, pExpectedType, pLogger);
    }

    Object convertStaticValueToExpectedType(String pValue, Class pExpectedType, Logger pLogger) throws XelException {
        if (pExpectedType == String.class || pExpectedType == Object.class) {
            return pValue;
        }
        Map valueByString = ExpressionEvaluatorImpl.getOrCreateExpectedTypeMap(pExpectedType);
        if (!this.mBypassCache && valueByString.containsKey(pValue)) {
            return valueByString.get(pValue);
        }
        Object ret = Coercions.coerce(pValue, pExpectedType, pLogger);
        valueByString.put(pValue, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map getOrCreateExpectedTypeMap(Class pExpectedType) {
        Map map = sCachedExpectedTypes;
        synchronized (map) {
            Map ret = (Map)sCachedExpectedTypes.get(pExpectedType);
            if (ret == null) {
                ret = Collections.synchronizedMap(new HashMap());
                sCachedExpectedTypes.put(pExpectedType, ret);
            }
            return ret;
        }
    }

    static String formatParseException(String pExpressionString, ParseException pExc) {
        StringBuffer expectedBuf = new StringBuffer();
        int maxSize = 0;
        boolean printedOne = false;
        if (pExc.expectedTokenSequences == null) {
            return pExc.toString();
        }
        for (int i = 0; i < pExc.expectedTokenSequences.length; ++i) {
            if (maxSize < pExc.expectedTokenSequences[i].length) {
                maxSize = pExc.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < pExc.expectedTokenSequences[i].length; ++j) {
                if (printedOne) {
                    expectedBuf.append(", ");
                }
                expectedBuf.append(pExc.tokenImage[pExc.expectedTokenSequences[i][j]]);
                printedOne = true;
            }
        }
        String expected = expectedBuf.toString();
        StringBuffer encounteredBuf = new StringBuffer();
        Token tok = pExc.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                encounteredBuf.append(" ");
            }
            if (tok.kind == 0) {
                encounteredBuf.append(pExc.tokenImage[0]);
                break;
            }
            encounteredBuf.append(ExpressionEvaluatorImpl.addEscapes(tok.image));
            tok = tok.next;
        }
        String encountered = encounteredBuf.toString();
        return MessageFormat.format(Constants.PARSE_EXCEPTION, expected, encountered);
    }

    static String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    public String parseAndRender(String pExpressionString) throws XelException {
        Object val = this.parseExpressionString(pExpressionString);
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Expression) {
            return "${" + ((Expression)val).getExpressionString() + "}";
        }
        if (val instanceof ExpressionString) {
            return ((ExpressionString)val).getExpressionString();
        }
        return "";
    }

    private class OldJSTLExpression
    extends ExpressionApi {
        private String expression;
        private Class expectedType;
        private FunctionMapper fMapper;
        Object parsedValue;

        public OldJSTLExpression(String expression, Object parsedValue, Class expectedType, FunctionMapper fMapper) {
            this.expression = expression;
            this.expectedType = expectedType;
            this.fMapper = fMapper;
            this.parsedValue = parsedValue;
        }

        public Object evaluate(VariableResolver vResolver) throws XelException {
            if (this.parsedValue instanceof String) {
                String strValue = (String)this.parsedValue;
                return ExpressionEvaluatorImpl.this.convertStaticValueToExpectedType(strValue, this.expectedType, sLogger);
            }
            if (this.parsedValue instanceof Expression) {
                Object value = ((Expression)this.parsedValue).evaluate(vResolver, this.fMapper, sLogger);
                return ExpressionEvaluatorImpl.this.convertToExpectedType(value, this.expectedType, sLogger);
            }
            if (this.parsedValue instanceof ExpressionString) {
                String strValue = ((ExpressionString)this.parsedValue).evaluate(vResolver, this.fMapper, sLogger);
                return ExpressionEvaluatorImpl.this.convertToExpectedType(strValue, this.expectedType, sLogger);
            }
            return null;
        }
    }

    private class JSTLExpression
    extends ELExpression {
        private String expression;
        private Class expectedType;
        Object parsedValue;

        public JSTLExpression(String expression, Object parsedValue, Class expectedType) {
            this.expression = expression;
            this.expectedType = expectedType;
            this.parsedValue = parsedValue;
        }

        public Object evaluate(VariableResolver vResolver, FunctionMapper fMapper) throws XelException {
            if (this.parsedValue instanceof String) {
                String strValue = (String)this.parsedValue;
                return ExpressionEvaluatorImpl.this.convertStaticValueToExpectedType(strValue, this.expectedType, sLogger);
            }
            if (this.parsedValue instanceof Expression) {
                Object value = ((Expression)this.parsedValue).evaluate(vResolver, fMapper, sLogger);
                return ExpressionEvaluatorImpl.this.convertToExpectedType(value, this.expectedType, sLogger);
            }
            if (this.parsedValue instanceof ExpressionString) {
                String strValue = ((ExpressionString)this.parsedValue).evaluate(vResolver, fMapper, sLogger);
                return ExpressionEvaluatorImpl.this.convertToExpectedType(strValue, this.expectedType, sLogger);
            }
            return null;
        }
    }
}

