/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import org.zkoss.lang.JVMs;
import org.zkoss.math.RoundingModes;
import org.zkoss.util.Locales;
import org.zkoss.zul.impl.FormatInputElement;

public abstract class NumberInputElement
extends FormatInputElement {
    private int _rounding = 6;

    public void setRoundingMode(int mode) {
        if (this._rounding != mode) {
            if (!JVMs.isJava6()) {
                throw new UnsupportedOperationException("Java 6 or above is required");
            }
            this._rounding = mode;
        }
    }

    public void setRoundingMode(String name) {
        this.setRoundingMode(RoundingModes.valueOf((String)name));
    }

    public int getRoundingMode() {
        return this._rounding;
    }

    protected String formatNumber(Object value, String defaultFormat) {
        String fmt;
        if (value == null) {
            return "";
        }
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(Locales.getCurrent());
        if (this._rounding != 6) {
            df.setRoundingMode(RoundingMode.valueOf(this._rounding));
        }
        if ((fmt = this.getFormat()) == null) {
            fmt = defaultFormat;
        }
        if (fmt != null) {
            df.applyPattern(fmt);
        }
        return df.format(value);
    }

    protected Object[] toNumberOnly(String val) {
        if (val == null) {
            return new Object[]{null, null};
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locales.getCurrent());
        char GROUPING = symbols.getGroupingSeparator();
        char DECIMAL = symbols.getDecimalSeparator();
        char PERCENT = symbols.getPercent();
        char PER_MILL = symbols.getPerMill();
        char MINUS = symbols.getMinusSign();
        String fmt = this.getFormat();
        StringBuffer sb = null;
        int divscale = 0;
        boolean minus = false;
        int len = val.length();
        for (int j = 0; j < len; ++j) {
            char c2;
            char cc = val.charAt(j);
            boolean ignore = false;
            if (cc == PERCENT) {
                divscale += 2;
                ignore = true;
            } else if (cc == PER_MILL) {
                divscale += 3;
                ignore = true;
            } else if (cc == '(') {
                minus = true;
                ignore = true;
            } else if (cc == '+') {
                ignore = true;
            }
            if (!ignore) {
                boolean bl = ignore = (cc < '0' || cc > '9') && cc != DECIMAL && cc != MINUS && cc != '+' && (Character.isWhitespace(cc) || cc == GROUPING || cc == ')' || fmt != null && fmt.indexOf(cc) >= 0);
            }
            if (ignore) {
                if (sb != null) continue;
                sb = new StringBuffer(len).append(val.substring(0, j));
                continue;
            }
            char c = cc == MINUS ? (char)'-' : (c2 = cc == DECIMAL ? (char)'.' : (char)cc);
            if (cc != c2) {
                if (sb == null) {
                    sb = new StringBuffer(len).append(val.substring(0, j));
                }
                sb.append(c2);
                continue;
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        if (minus) {
            if (sb == null) {
                sb = new StringBuffer(val.length() + 1).append(val);
            }
            if (sb.length() > 0) {
                if (sb.charAt(0) == '-') {
                    sb.deleteCharAt(0);
                } else {
                    sb.insert(0, '-');
                }
            }
        }
        return new Object[]{sb != null ? sb.toString() : val, new Integer(divscale)};
    }
}

