/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.api.Tabpanel;
import org.zkoss.zul.api.Tabpanels;
import org.zkoss.zul.impl.XulElement;

public class Tabbox
extends XulElement
implements org.zkoss.zul.api.Tabbox {
    private transient Tabs _tabs;
    private transient Toolbar _toolbar;
    private transient org.zkoss.zul.Tabpanels _tabpanels;
    private transient Tab _seltab;
    private String _panelSpacing;
    private String _orient = "horizontal";
    private boolean _tabscroll = true;
    transient EventListener _listener;

    public Tabbox() {
        this.init();
    }

    private void init() {
        this._listener = new Listener();
    }

    boolean inAccordionMold() {
        return this.getMold().startsWith("accordion");
    }

    public Tabs getTabs() {
        return this._tabs;
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public org.zkoss.zul.api.Tabs getTabsApi() {
        return this.getTabs();
    }

    public org.zkoss.zul.Tabpanels getTabpanels() {
        return this._tabpanels;
    }

    public Tabpanels getTabpanelsApi() {
        return this.getTabpanels();
    }

    public boolean isTabscroll() {
        return this._tabscroll;
    }

    public void setTabscroll(boolean tabscroll) {
        if (this._tabscroll != tabscroll) {
            this._tabscroll = tabscroll;
            this.smartUpdate("tabscroll", this._tabscroll);
        }
    }

    public String getPanelSpacing() {
        return this._panelSpacing;
    }

    public void setPanelSpacing(String panelSpacing) {
        if (panelSpacing != null && panelSpacing.length() == 0) {
            panelSpacing = null;
        }
        if (!Objects.equals((Object)this._panelSpacing, (Object)panelSpacing)) {
            this._panelSpacing = panelSpacing;
            this.smartUpdate("panelSpacing", this._panelSpacing);
        }
    }

    public int getSelectedIndex() {
        return this._seltab != null ? this._seltab.getIndex() : -1;
    }

    public void setSelectedIndex(int j) {
        Tabs tabs = this.getTabs();
        if (tabs == null) {
            throw new IllegalStateException("No tab at all");
        }
        this.setSelectedTab((Tab)tabs.getChildren().get(j));
    }

    public org.zkoss.zul.Tabpanel getSelectedPanel() {
        return this._seltab != null ? this._seltab.getLinkedPanel() : null;
    }

    public Tabpanel getSelectedPanelApi() {
        return this.getSelectedPanel();
    }

    public void setSelectedPanel(org.zkoss.zul.Tabpanel panel) {
        if (panel != null && panel.getTabbox() != this) {
            throw new UiException("Not a child: " + panel);
        }
        Tab tab = panel.getLinkedTab();
        if (tab != null) {
            this.setSelectedTab(tab);
        }
    }

    public void setSelectedPanelApi(Tabpanel panelApi) {
        org.zkoss.zul.Tabpanel panel = (org.zkoss.zul.Tabpanel)panelApi;
        this.setSelectedPanel(panel);
    }

    public Tab getSelectedTab() {
        return this._seltab;
    }

    public org.zkoss.zul.api.Tab getSelectedTabApi() {
        return this.getSelectedTab();
    }

    public void setSelectedTab(Tab tab) {
        this.selectTabDirectly(tab, false);
    }

    public void setSelectedTabApi(org.zkoss.zul.api.Tab tabApi) {
        Tab tab = (Tab)tabApi;
        this.setSelectedTab(tab);
    }

    void selectTabDirectly(Tab tab, boolean byClient) {
        if (tab == null) {
            throw new IllegalArgumentException("null tab");
        }
        if (tab.getTabbox() != this) {
            throw new UiException("Not my child: " + tab);
        }
        if (tab != this._seltab) {
            if (this._seltab != null) {
                this._seltab.setSelectedDirectly(false);
            }
            this._seltab = tab;
            this._seltab.setSelectedDirectly(true);
            if (!byClient) {
                this.smartUpdate("selectedTab", this._seltab.getUuid());
            }
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("accordion")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("Unknow orient : " + orient);
        }
        if (this.inAccordionMold()) {
            throw new WrongValueException("Unsupported vertical orient in mold : " + this.getMold());
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public String getZclass() {
        return this._zclass == null ? "z-tabbox" + (this.inAccordionMold() ? "-" + this.getMold() : (this.isVertical() ? "-ver" : "")) : this._zclass;
    }

    public void onCreate() {
        if (this._tabs != null) {
            int sz = this._tabs.getChildren().size();
            if (this._tabpanels == null) {
                this.insertBefore((Component)new org.zkoss.zul.Tabpanels(), null);
            }
            for (int n = this._tabpanels.getChildren().size(); n < sz; ++n) {
                this._tabpanels.insertBefore((Component)new org.zkoss.zul.Tabpanel(), null);
            }
            if (sz > 0 && this._seltab == null) {
                this.setSelectedTab((Tab)this._tabs.getFirstChild());
            }
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Toolbar) {
            if (this._toolbar != null && this._toolbar != child) {
                throw new UiException("Only one Toolbar is allowed: " + this);
            }
        } else if (child instanceof Tabs) {
            if (this._tabs != null && this._tabs != child) {
                throw new UiException("Only one tabs is allowed: " + this);
            }
        } else if (child instanceof org.zkoss.zul.Tabpanels) {
            if (this._tabpanels != null && this._tabpanels != child) {
                throw new UiException("Only one tabpanels is allowed: " + this);
            }
        } else {
            throw new UiException("Unsupported child for tabbox: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Tabs) {
            if (super.insertBefore(child, refChild)) {
                this._tabs = (Tabs)child;
                Iterator it = this._tabs.getChildren().iterator();
                while (it.hasNext()) {
                    Tab tab = (Tab)it.next();
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                this.addTabsListeners();
                return true;
            }
        } else if (child instanceof org.zkoss.zul.Tabpanels) {
            if (super.insertBefore(child, refChild)) {
                this._tabpanels = (org.zkoss.zul.Tabpanels)child;
                return true;
            }
        } else if (child instanceof Toolbar) {
            if (super.insertBefore(child, refChild)) {
                this._toolbar = (Toolbar)child;
                return true;
            }
        } else {
            return super.insertBefore(child, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (this._tabs == child) {
            this.removeTabsListeners();
            this._tabs = null;
            this._seltab = null;
        } else if (this._tabpanels == child) {
            this._tabpanels = null;
        } else if (this._toolbar == child) {
            this._toolbar = null;
        }
        super.onChildRemoved(child);
    }

    private void removeTabsListeners() {
        if (this._tabs != null) {
            Iterator it = this._tabs.getChildren().iterator();
            while (it.hasNext()) {
                Tab tab = (Tab)it.next();
                tab.removeEventListener("onSelect", this._listener);
            }
        }
    }

    private void addTabsListeners() {
        if (this._tabs != null) {
            Iterator it = this._tabs.getChildren().iterator();
            while (it.hasNext()) {
                Tab tab = (Tab)it.next();
                tab.addEventListener("onSelect", this._listener);
            }
        }
    }

    public Object clone() {
        Tabbox clone = (Tabbox)super.clone();
        clone.removeTabsListeners();
        clone.init();
        int cnt = 0;
        if (clone._tabs != null) {
            ++cnt;
        }
        if (clone._toolbar != null) {
            ++cnt;
        }
        if (clone._tabpanels != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Tabs) {
                this._tabs = (Tabs)child;
                Iterator e = this._tabs.getChildren().iterator();
                while (e.hasNext()) {
                    Tab tab = (Tab)e.next();
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Toolbar) {
                this._toolbar = (Toolbar)child;
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof org.zkoss.zul.Tabpanels)) continue;
            this._tabpanels = (org.zkoss.zul.Tabpanels)child;
            if (--cnt != 0) continue;
            break;
        }
        this.addTabsListeners();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal(-1);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._seltab != null) {
            this.render(renderer, "selectedTab", this._seltab.getUuid());
        }
        if (this._panelSpacing != null) {
            this.render(renderer, "panelSpacing", this._panelSpacing);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        if (this._tabscroll) {
            this.render(renderer, "tabscroll", this._tabscroll);
        }
    }

    private class Listener
    implements EventListener,
    Deferrable {
        private Listener() {
        }

        public void onEvent(Event event) {
            Events.sendEvent((Component)Tabbox.this, (Event)event);
        }

        public boolean isDeferrable() {
            return !Events.isListened((Component)Tabbox.this, (String)"onSelect", (boolean)true);
        }
    }
}

